/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.Entities;
import sf.util.Utility;

class TableCell {
    private final OutputFormat outputFormat;
    private final String styleClass;
    private final int colSpan;
    private final int characterWidth;
    private final Alignment align;
    private final String text;

    private static String escapeAndQuoteCsv(String text) {
        int QUOTE = 34;
        int SEPARATOR = 44;
        String value = String.valueOf(text);
        int length = value.length();
        if (length == 0) {
            return "\"\"";
        }
        if (value.indexOf(44) < 0 && value.indexOf(34) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append('\"').append(c);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    TableCell(String text, int characterWidth, Alignment align, int colSpan, String styleClass, OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        this.colSpan = colSpan;
        this.styleClass = styleClass;
        this.text = text;
        this.characterWidth = characterWidth;
        this.align = align;
    }

    public String toString() {
        if (this.outputFormat == OutputFormat.html) {
            return this.toHtmlString();
        }
        return this.toPlainTextString();
    }

    protected String getCellTag() {
        return "td";
    }

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(this.getCellTag());
        if (this.colSpan > 1) {
            buffer.append(" colspan='").append(this.colSpan).append("'");
        }
        if (!Utility.isBlank((String)this.styleClass)) {
            buffer.append(" class='").append(this.styleClass).append("'");
        }
        buffer.append(">");
        if (this.text == null) {
            buffer.append("NULL");
        } else {
            buffer.append(Entities.XML.escape(String.valueOf(this.text)));
        }
        buffer.append("</").append(this.getCellTag()).append(">");
        return buffer.toString();
    }

    private String toPlainTextString() {
        String value;
        String string = value = this.text == null ? "NULL" : this.text;
        if (this.outputFormat == OutputFormat.csv) {
            return TableCell.escapeAndQuoteCsv(value);
        }
        if (this.outputFormat == OutputFormat.tsv) {
            return String.valueOf(value);
        }
        if (this.characterWidth > 0) {
            if (this.align == Alignment.right) {
                return String.format("%" + this.characterWidth + "s", value);
            }
            return String.format("%-" + this.characterWidth + "s", value);
        }
        return value;
    }
}

