/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.BinaryData;
import schemacrawler.tools.text.utility.TableCell;
import schemacrawler.tools.text.utility.TableHeaderCell;
import schemacrawler.tools.text.utility.TableRow;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.Utility;

abstract class BaseTextFormattingHelper
implements TextFormattingHelper {
    static final String DASHED_SEPARATOR = BaseTextFormattingHelper.separator("-");
    private final OutputFormat outputFormat;

    static String separator(String pattern) {
        StringBuilder dashedSeparator = new StringBuilder(72);
        for (int i = 0; i < 72 / pattern.length(); ++i) {
            dashedSeparator.append(pattern);
        }
        return dashedSeparator.toString();
    }

    BaseTextFormattingHelper(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public String createDefinitionRow(String definition) {
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(definition, 0, Alignment.left, 3, "definition", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createDescriptionRow(String description) {
        TableRow row = new TableRow(this.outputFormat);
        row.add(this.newTableCell("", "ordinal", this.outputFormat));
        row.add(new TableCell(description, 0, Alignment.left, 2, "definition", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createDetailRow(String ordinal, String subName, String type) {
        int subNameWidth = 32;
        int typeWidth = 28;
        TableRow row = new TableRow(this.outputFormat);
        if (Utility.isBlank((String)ordinal)) {
            row.add(this.newTableCell("", "ordinal", this.outputFormat));
        } else {
            row.add(new TableCell(ordinal, 2, Alignment.left, 1, "ordinal", this.outputFormat));
        }
        row.add(new TableCell(subName, 32, Alignment.left, 1, "subname", this.outputFormat));
        row.add(new TableCell(type, 28, Alignment.left, 1, "type", this.outputFormat));
        return row.toString();
    }

    @Override
    public String createEmptyRow() {
        return new TableRow(this.outputFormat, 3).toString();
    }

    @Override
    public String createNameRow(String name, String description) {
        int nameWidth = 34;
        int descriptionWidth = 36;
        if (name.length() > nameWidth && description.length() < descriptionWidth) {
            descriptionWidth = Math.max(description.length(), descriptionWidth - (name.length() - nameWidth));
        }
        if (description.length() > descriptionWidth && name.length() < nameWidth) {
            nameWidth = Math.max(name.length(), nameWidth - (description.length() - descriptionWidth));
        }
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(name, nameWidth, Alignment.left, 2, "name", this.outputFormat));
        row.add(new TableCell(description, descriptionWidth, Alignment.right, 1, "description right", this.outputFormat));
        String nameRowString = row.toString();
        return nameRowString;
    }

    @Override
    public String createNameValueRow(String name, String value, Alignment valueAlignment) {
        int nameWidth = 40;
        int valueWidth = 30;
        Alignment alignmentForValue = valueAlignment == null ? Alignment.left : valueAlignment;
        String valueStyle = "property_value" + (alignmentForValue == Alignment.left ? "" : " right");
        TableRow row = new TableRow(this.outputFormat);
        row.add(new TableCell(name, 40, Alignment.left, 1, "property_name", this.outputFormat));
        row.add(new TableCell(value, 30, alignmentForValue, 1, valueStyle, this.outputFormat));
        return row.toString();
    }

    @Override
    public String createRow(Object ... columnData) {
        OutputFormat outputFormat = this.outputFormat;
        if (outputFormat == OutputFormat.text) {
            outputFormat = OutputFormat.tsv;
        }
        TableRow row = new TableRow(outputFormat);
        for (Object element : columnData) {
            if (element == null) {
                row.add(this.newTableCell(null, "data_null", outputFormat));
                continue;
            }
            if (element instanceof BinaryData) {
                row.add(this.newTableCell(element.toString(), "data_binary", outputFormat));
                continue;
            }
            if (element instanceof Number) {
                row.add(this.newTableCell(element.toString(), "data_number", outputFormat));
                continue;
            }
            row.add(this.newTableCell(element.toString(), "", outputFormat));
        }
        return row.toString();
    }

    @Override
    public String createRowHeader(String ... columnNames) {
        OutputFormat outputFormat = this.outputFormat;
        if (outputFormat == OutputFormat.text) {
            outputFormat = OutputFormat.tsv;
        }
        TableRow row = new TableRow(outputFormat);
        for (String columnName : columnNames) {
            TableHeaderCell headerCell = new TableHeaderCell(columnName, 0, Alignment.left, 1, "", outputFormat);
            row.add(headerCell);
        }
        return row.toString();
    }

    private TableCell newTableCell(String text, String styleClass, OutputFormat outputFormat) {
        return new TableCell(text, 0, Alignment.left, 1, styleClass, outputFormat);
    }
}

