/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.CommandDaisyChainExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.text.operation.OperationExecutable;

public final class SchemaCrawlerExecutable
extends BaseExecutable {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerExecutable.class.getName());

    public SchemaCrawlerExecutable(String command) throws SchemaCrawlerException {
        super(command);
    }

    @Override
    protected void executeOn(Database database, Connection connection) throws Exception {
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        BaseExecutable executable = null;
        CommandRegistry commandRegistry = new CommandRegistry();
        for (String command : commands) {
            boolean isConfiguredQuery;
            boolean isCommand = commandRegistry.hasCommand(command);
            boolean bl = isConfiguredQuery = this.additionalConfiguration != null && this.additionalConfiguration.containsKey((Object)command);
            if (isCommand || isConfiguredQuery) continue;
            LOGGER.log(Level.INFO, String.format("Executing as a query, %s", this.getCommand()));
            executable = new OperationExecutable(this.getCommand());
            break;
        }
        if (executable == null) {
            if (commands.hasMultipleCommands()) {
                LOGGER.log(Level.INFO, String.format("Executing commands [%s] in sequence", commands));
                executable = new CommandDaisyChainExecutable(this.getCommand());
            } else {
                executable = (BaseExecutable)commandRegistry.newExecutable(this.getCommand());
                LOGGER.log(Level.INFO, String.format("Executing command \"%s\" using executable %s", this.getCommand(), executable.getClass().getName()));
            }
        }
        executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        executable.setAdditionalConfiguration(this.additionalConfiguration);
        executable.setOutputOptions(this.outputOptions);
        executable.executeOn(database, connection);
    }
}

