/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.analysis.associations.Inflection;
import schemacrawler.tools.analysis.associations.WeakAssociation;
import sf.util.Multimap;
import sf.util.ObjectToString;
import sf.util.Utility;

final class WeakAssociationsAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationsAnalyzer.class.getName());
    private final List<Table> tables;
    private final Collection<ColumnReference> weakAssociations;

    WeakAssociationsAnalyzer(List<Table> tables) {
        this.tables = tables;
        this.weakAssociations = new TreeSet<ColumnReference>();
    }

    Collection<ColumnReference> analyzeTables() {
        if (this.tables == null || this.tables.size() < 3) {
            return Collections.emptySet();
        }
        Collection<String> prefixes = this.findTableNamePrefixes(this.tables);
        Multimap<String, Table> tableMatchMap = this.mapTableNameMatches(this.tables, prefixes);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Table prefixes=" + prefixes);
            LOGGER.log(Level.FINE, "Table matches map:" + ObjectToString.toString(tableMatchMap));
        }
        Map<String, ForeignKeyColumnReference> fkColumnsMap = this.mapForeignKeyColumns(this.tables);
        this.findWeakAssociations(this.tables, tableMatchMap, fkColumnsMap);
        return this.weakAssociations;
    }

    private void addWeakAssociation(Column fkColumn, Column pkColumn) {
        LOGGER.log(Level.FINE, String.format("Found weak association: %s --> %s", fkColumn.getFullName(), pkColumn.getFullName()));
        if (this.weakAssociations != null) {
            WeakAssociation weakAssociation = new WeakAssociation(pkColumn, fkColumn);
            this.addWeakAssociation(weakAssociation);
        }
    }

    private void addWeakAssociation(ColumnReference weakAssociation) {
        if (weakAssociation != null) {
            this.weakAssociations.add(weakAssociation);
            DatabaseWithAssociations.addWeakAssociationToTable((Table)weakAssociation.getPrimaryKeyColumn().getParent(), weakAssociation);
            DatabaseWithAssociations.addWeakAssociationToTable((Table)weakAssociation.getForeignKeyColumn().getParent(), weakAssociation);
        }
    }

    private Collection<String> findTableNamePrefixes(List<Table> tables) {
        TreeMap<String, Integer> prefixesMap = new TreeMap<String, Integer>();
        for (int i = 0; i < tables.size(); ++i) {
            for (int j = i + 1; j < tables.size(); ++j) {
                String table2;
                String table1 = tables.get(i).getName();
                String commonPrefix = Utility.commonPrefix((String)table1, (String)(table2 = tables.get(j).getName()));
                if (Utility.isBlank((String)commonPrefix) || !commonPrefix.endsWith("_")) continue;
                ArrayList<String> splitCommonPrefixes = new ArrayList<String>();
                String[] splitPrefix = commonPrefix.split("_");
                if (splitPrefix != null && splitPrefix.length > 0) {
                    for (int k = 0; k < splitPrefix.length; ++k) {
                        StringBuilder buffer = new StringBuilder();
                        for (int l = 0; l < k; ++l) {
                            buffer.append(splitPrefix[l]).append("_");
                        }
                        if (buffer.length() <= 0) continue;
                        splitCommonPrefixes.add(buffer.toString());
                    }
                }
                splitCommonPrefixes.add(commonPrefix);
                for (String splitCommonPrefix : splitCommonPrefixes) {
                    int prevCount = prefixesMap.containsKey(splitCommonPrefix) ? (Integer)prefixesMap.get(splitCommonPrefix) : 0;
                    prefixesMap.put(splitCommonPrefix, prevCount + 1);
                }
            }
        }
        ArrayList keySet = new ArrayList(prefixesMap.keySet());
        Collections.sort(keySet, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int comparison = 0;
                comparison = o2.length() - o1.length();
                if (comparison == 0) {
                    comparison = o2.compareTo(o1);
                }
                return comparison;
            }
        });
        block5: for (int i = 0; i < keySet.size(); ++i) {
            for (int j = i + 1; j < keySet.size(); ++j) {
                String longPrefix = (String)keySet.get(i);
                if (!longPrefix.startsWith((String)keySet.get(j))) continue;
                prefixesMap.remove(longPrefix);
                continue block5;
            }
        }
        ArrayList prefixesList = new ArrayList(prefixesMap.entrySet());
        Collections.sort(prefixesList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < prefixesList.size(); ++i) {
            boolean add;
            boolean bl = add = i < 5 || (double)((Integer)((Map.Entry)prefixesList.get(i)).getValue()).intValue() > (double)prefixesMap.size() * 0.5;
            if (!add) continue;
            prefixes.add((String)((Map.Entry)prefixesList.get(i)).getKey());
        }
        prefixes.add("");
        return prefixes;
    }

    private void findWeakAssociations(List<Table> tables, Multimap<String, Table> tableMatchMap, Map<String, ForeignKeyColumnReference> fkColumnsMap) {
        for (Table table : tables) {
            Map<String, Column> columnNameMatchesMap = this.mapColumnNameMatches(table);
            for (Map.Entry<String, Column> columnEntry : columnNameMatchesMap.entrySet()) {
                String matchColumnName = columnEntry.getKey();
                List matchedTables = (List)tableMatchMap.get((Object)matchColumnName);
                if (matchedTables == null) continue;
                for (Table matchedTable : matchedTables) {
                    Map<String, Column> pkColumnNameMatchesMap;
                    Column pkColumn;
                    ForeignKeyColumnReference fkColumnReference;
                    Column fkColumn = columnEntry.getValue();
                    if (matchedTable == null || fkColumn == null || ((Table)fkColumn.getParent()).equals(matchedTable) || (fkColumnReference = fkColumnsMap.get(fkColumn.getFullName())) != null && ((Table)fkColumnReference.getPrimaryKeyColumn().getParent()).equals(matchedTable) || (pkColumn = (pkColumnNameMatchesMap = this.mapColumnNameMatches(matchedTable)).get("id")) == null) continue;
                    ColumnDataType fkColumnType = fkColumn.getColumnDataType();
                    ColumnDataType pkColumnType = pkColumn.getColumnDataType();
                    if (pkColumnType == null || fkColumnType == null || fkColumnType.getType() != pkColumnType.getType()) continue;
                    this.addWeakAssociation(fkColumn, pkColumn);
                }
            }
        }
    }

    private Map<String, Column> mapColumnNameMatches(Table table) {
        HashMap<String, Column> matchMap = new HashMap<String, Column>();
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null && primaryKey.getColumns().size() == 1) {
            matchMap.put("id", (Column)primaryKey.getColumns().get(0));
        }
        for (Column column : table.getColumns()) {
            String matchColumnName = column.getName().toLowerCase();
            if (matchColumnName.endsWith("_id")) {
                matchColumnName = matchColumnName.substring(0, matchColumnName.length() - 3);
            }
            if (matchColumnName.endsWith("id") && !matchColumnName.equals("id")) {
                matchColumnName = matchColumnName.substring(0, matchColumnName.length() - 2);
            }
            matchMap.put(matchColumnName, column);
        }
        return matchMap;
    }

    private Map<String, ForeignKeyColumnReference> mapForeignKeyColumns(List<Table> tables) {
        HashMap<String, ForeignKeyColumnReference> fkColumnsMap = new HashMap<String, ForeignKeyColumnReference>();
        for (Table table : tables) {
            for (ForeignKey fk : table.getForeignKeys()) {
                for (ForeignKeyColumnReference fkMap : fk.getColumnReferences()) {
                    fkColumnsMap.put(fkMap.getForeignKeyColumn().getFullName(), fkMap);
                }
            }
        }
        return fkColumnsMap;
    }

    private Multimap<String, Table> mapTableNameMatches(List<Table> tables, Collection<String> prefixes) {
        Multimap matchMap = new Multimap();
        for (Table table : tables) {
            for (String prefix : prefixes) {
                String matchTableName = table.getName().toLowerCase();
                if (!matchTableName.startsWith(prefix)) continue;
                matchTableName = matchTableName.substring(prefix.length());
                matchTableName = Inflection.singularize(matchTableName);
                matchMap.add((Object)matchTableName, (Object)table);
            }
        }
        matchMap.remove((Object)"");
        return matchMap;
    }
}

