/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.Utility;

abstract class BaseDatabaseConnectionOptions
implements ConnectionOptions {
    private static final long serialVersionUID = -8141436553988174836L;
    private static final Logger LOGGER = Logger.getLogger(BaseDatabaseConnectionOptions.class.getName());
    private Map<String, String> connectionProperties;
    private String user;
    private String password;

    BaseDatabaseConnectionOptions() {
    }

    static void loadJdbcDriver(String jdbcDriverClassName) throws SchemaCrawlerException {
        try {
            Class.forName(jdbcDriverClassName);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load JDBC driver, " + jdbcDriverClassName, e);
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public final Connection getConnection(String user, String password) throws SQLException {
        String connectionUrl;
        if (user == null) {
            LOGGER.log(Level.WARNING, "Database user is not provided");
        }
        if (password == null) {
            LOGGER.log(Level.WARNING, "Database password is not provided");
        }
        try {
            connectionUrl = this.getConnectionUrl();
        }
        catch (Exception e) {
            throw new SQLException(String.format("Could not connect to database, for user %s", user), e);
        }
        Properties jdbcConnectionProperties = new Properties();
        if (this.connectionProperties != null) {
            jdbcConnectionProperties.putAll(this.connectionProperties);
        }
        if (user != null) {
            jdbcConnectionProperties.put("user", user);
        }
        if (password != null) {
            jdbcConnectionProperties.put("password", password);
        }
        try {
            LOGGER.log(Level.INFO, String.format("Making connection to %s, with user %s", connectionUrl, user));
            Connection connection = DriverManager.getConnection(connectionUrl, jdbcConnectionProperties);
            return connection;
        }
        catch (SQLException e) {
            jdbcConnectionProperties.remove("password");
            throw new SchemaCrawlerSQLException(String.format("Could not connect to %s, with properties %s", connectionUrl, jdbcConnectionProperties), e);
        }
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public final Driver getJdbcDriver() {
        try {
            return DriverManager.getDriver(this.getConnectionUrl());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not get a database driver for database connection URL " + this.getConnectionUrl());
            return null;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void setConnectionProperties(Map<String, String> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setConnectionProperties(String connectionPropertiesString) {
        this.connectionProperties = new HashMap<String, String>();
        if (!Utility.isBlank(connectionPropertiesString)) {
            for (String property : connectionPropertiesString.split(";")) {
                String[] propertyValues;
                if (Utility.isBlank(property) || (propertyValues = property.split("=")).length < 1) continue;
                String key = propertyValues[0];
                String value = propertyValues.length >= 2 ? propertyValues[1] : null;
                this.connectionProperties.put(key, value);
            }
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (out != null) {
            throw new SQLFeatureNotSupportedException("Not supported");
        }
    }

    @Override
    public final void setPassword(String password) {
        this.password = password;
    }

    @Override
    public final void setUser(String user) {
        this.user = user;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("driver=").append(this.getJdbcDriver().getClass().getName()).append(Utility.NEWLINE);
        builder.append("url=").append(this.getConnectionUrl()).append(Utility.NEWLINE);
        builder.append("user=").append(this.getUser()).append(Utility.NEWLINE);
        return builder.toString();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }
}

