/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.filter.FilterFactory;
import schemacrawler.filter.NamedObjectFilter;
import schemacrawler.schema.Routine;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class RoutineFilter {
    private final SchemaCrawlerOptions options;
    private final NamedObjectList<MutableRoutine> allRoutines;

    public RoutineFilter(SchemaCrawlerOptions options, NamedObjectList<MutableRoutine> allRoutines) {
        this.options = options;
        this.allRoutines = allRoutines;
    }

    public void filter() {
        Collection<MutableRoutine> filteredRoutines = this.doFilter();
        for (MutableRoutine routine : this.allRoutines) {
            if (filteredRoutines.contains(routine)) continue;
            this.allRoutines.remove(routine);
        }
    }

    private Collection<MutableRoutine> doFilter() {
        NamedObjectFilter<Routine> routineFilter = FilterFactory.grepRoutinesFilter(this.options);
        HashSet<MutableRoutine> greppedRoutines = new HashSet<MutableRoutine>();
        for (MutableRoutine routine : this.allRoutines) {
            if (!routineFilter.include(routine)) continue;
            greppedRoutines.add(routine);
        }
        return greppedRoutines;
    }
}

