/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.ast;

import java.io.PrintWriter;
import java.io.Writer;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.vm.ast.NodeUtils;
import net.sourceforge.pmd.lang.vm.ast.Token;
import net.sourceforge.pmd.lang.vm.ast.VmNode;
import net.sourceforge.pmd.lang.vm.ast.VmParser;
import net.sourceforge.pmd.lang.vm.ast.VmParserTreeConstants;
import net.sourceforge.pmd.lang.vm.ast.VmParserVisitor;
import org.apache.commons.lang3.text.StrBuilder;

public class AbstractVmNode
extends AbstractNode
implements VmNode {
    protected VmParser parser;
    protected int info;
    public boolean state;
    protected boolean invalid = false;
    protected Token first;
    protected Token last;
    protected String templateName;

    public AbstractVmNode(int i) {
        super(i);
    }

    public AbstractVmNode(VmParser p, int i) {
        this(i);
        this.parser = p;
        this.templateName = this.parser.currentTemplateName;
    }

    public void jjtOpen() {
        this.first = this.parser.getToken(1);
        if (this.beginLine == -1 && this.parser.token.next != null) {
            this.beginLine = this.parser.token.next.beginLine;
            this.beginColumn = this.parser.token.next.beginColumn;
        }
    }

    public void jjtClose() {
        this.last = this.parser.getToken(0);
        if (this.beginLine == -1 && (this.children == null || this.children.length == 0)) {
            this.beginColumn = this.parser.token.beginColumn;
        }
        if (this.beginLine == -1) {
            this.beginLine = this.parser.token.beginLine;
        }
        this.endLine = this.parser.token.endLine;
        this.endColumn = this.parser.token.endColumn;
    }

    public void setFirstToken(Token t) {
        this.first = t;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    @Override
    public Object jjtAccept(VmParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object childrenAccept(VmParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ((VmNode)this.children[i]).jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String getXPathNodeName() {
        return VmParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    @Deprecated
    public void dump(String prefix, boolean recurse, Writer writer) {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        printWriter.println(this.toString(prefix));
        if (this.children != null && recurse) {
            for (int i = 0; i < this.children.length; ++i) {
                AbstractVmNode n = (AbstractVmNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ", recurse, printWriter);
            }
        }
    }

    public String literal() {
        if (this.first != null && this.first.equals(this.last)) {
            return NodeUtils.tokenLiteral(this.first);
        }
        Token t = this.first;
        StrBuilder sb = new StrBuilder(NodeUtils.tokenLiteral(t));
        while (t != null && !t.equals(this.last)) {
            t = t.next;
            sb.append(NodeUtils.tokenLiteral(t));
        }
        return sb.toString();
    }

    public int getType() {
        return this.id;
    }

    public void setInfo(int info) {
        this.info = info;
    }

    public int getInfo() {
        return this.info;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public int getLine() {
        return this.first.beginLine;
    }

    public int getColumn() {
        return this.first.beginColumn;
    }

    public String getTemplateName() {
        return this.templateName;
    }
}

