/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.velocity.rule.bestpractices;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.velocity.ast.ASTBlock;
import net.sourceforge.pmd.lang.velocity.ast.ASTDirective;
import net.sourceforge.pmd.lang.velocity.ast.ASTReference;
import net.sourceforge.pmd.lang.velocity.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.velocity.rule.AbstractVtlRule;

public class UnusedMacroParameterRule
extends AbstractVtlRule {
    @Override
    public Object visit(ASTDirective node, Object data) {
        if ("macro".equals(node.getDirectiveName())) {
            HashSet<String> paramNames = new HashSet<String>();
            for (ASTReference param : node.children(ASTReference.class)) {
                paramNames.add(param.literal());
            }
            ASTBlock macroBlock = (ASTBlock)node.firstChild(ASTBlock.class);
            if (macroBlock != null) {
                for (ASTReference referenceInMacro : macroBlock.descendants(ASTReference.class)) {
                    this.checkForParameter(paramNames, referenceInMacro.literal());
                }
                for (ASTStringLiteral literalInMacro : macroBlock.descendants(ASTStringLiteral.class)) {
                    String text = literalInMacro.literal();
                    this.checkForParameter(paramNames, text);
                }
            }
            if (!paramNames.isEmpty()) {
                this.asCtx(data).addViolation((Node)node, new Object[]{((Object)paramNames).toString()});
            }
        }
        return super.visit(node, data);
    }

    private void checkForParameter(Set<String> paramNames, String nameToSearch) {
        HashSet<String> paramsContained = new HashSet<String>();
        for (String param : paramNames) {
            if (!this.containsAny(nameToSearch, this.formatNameVariations(param))) continue;
            paramsContained.add(param);
        }
        paramNames.removeAll(paramsContained);
    }

    private boolean containsAny(String text, String[] formatNameVariations) {
        for (String formattedName : formatNameVariations) {
            if (!text.contains(formattedName)) continue;
            return true;
        }
        return false;
    }

    private String[] formatNameVariations(String param) {
        String actualName = param.substring(1);
        return new String[]{param, "${" + actualName + "}", "${" + actualName + ".", "$!" + actualName, "$!{" + actualName + ".", "$!{" + actualName + "}"};
    }
}

