/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.velocity.rule.bestpractices;

import java.util.HashSet;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.velocity.ast.ASTDirective;
import net.sourceforge.pmd.lang.velocity.ast.ASTReference;
import net.sourceforge.pmd.lang.velocity.ast.ASTSetDirective;
import net.sourceforge.pmd.lang.velocity.rule.AbstractVtlRule;

public class AvoidReassigningParametersRule
extends AbstractVtlRule {
    @Override
    public Object visit(ASTDirective node, Object data) {
        if ("macro".equals(node.getDirectiveName())) {
            HashSet<String> paramNames = new HashSet<String>();
            for (ASTReference param : node.children(ASTReference.class)) {
                paramNames.add(param.getFirstToken().getImage());
            }
            for (ASTSetDirective assignment : node.descendants(ASTSetDirective.class)) {
                ASTReference ref = (ASTReference)assignment.firstChild(ASTReference.class);
                if (ref == null || !paramNames.contains(ref.getFirstToken().getImage())) continue;
                this.asCtx(data).addViolation((Node)node, new Object[]{ref.getFirstToken().getImage()});
            }
        }
        return super.visit(node, data);
    }
}

