/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.swift.rule.bestpractices;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.swift.ast.SwiftParser;
import net.sourceforge.pmd.lang.swift.ast.SwiftVisitor;
import net.sourceforge.pmd.lang.swift.ast.SwiftVisitorBase;
import net.sourceforge.pmd.lang.swift.rule.AbstractSwiftRule;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnavailableFunctionRule
extends AbstractSwiftRule {
    private static final Pattern AVAILABLE_UNAVAILABLE = Pattern.compile("^\\s*@available\\s*\\(\\s*\\*\\s*,\\s*unavailable\\s*\\)\\s*$", 2);
    private static final String FATAL_ERROR = "fatalError";

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(SwiftParser.SwFunctionDeclaration.class, (Class[])new Class[]{SwiftParser.SwInitializerDeclaration.class});
    }

    @Override
    public SwiftVisitor<RuleContext, ?> buildVisitor() {
        return new SwiftVisitorBase<RuleContext, Void>(){

            @Override
            public Void visitFunctionDeclaration(SwiftParser.SwFunctionDeclaration ctx, RuleContext ruleCtx) {
                SwiftParser.SwAttributes attributes;
                if (ctx == null) {
                    return null;
                }
                if (this.shouldIncludeUnavailableModifier(ctx.functionBody().codeBlock()) && ((attributes = ctx.functionHead().attributes()) == null || !this.hasUnavailableModifier(attributes.attribute()))) {
                    ruleCtx.addViolation((Node)ctx);
                }
                return null;
            }

            @Override
            public Void visitInitializerDeclaration(SwiftParser.SwInitializerDeclaration ctx, RuleContext ruleCtx) {
                SwiftParser.SwAttributes attributes;
                if (ctx == null) {
                    return null;
                }
                if (this.shouldIncludeUnavailableModifier(ctx.initializerBody().codeBlock()) && ((attributes = ctx.initializerHead().attributes()) == null || !this.hasUnavailableModifier(attributes.attribute()))) {
                    ruleCtx.addViolation((Node)ctx);
                }
                return null;
            }

            private boolean shouldIncludeUnavailableModifier(SwiftParser.SwCodeBlock ctx) {
                if (ctx == null || ctx.statements() == null) {
                    return false;
                }
                List<SwiftParser.SwStatement> statements = ctx.statements().statement();
                return statements.size() == 1 && UnavailableFunctionRule.FATAL_ERROR.equals(statements.get(0).getFirstAntlrToken().getText());
            }

            private boolean hasUnavailableModifier(List<SwiftParser.SwAttribute> attributes) {
                return attributes.stream().anyMatch(attr -> {
                    Chars text = attr.getTextDocument().sliceTranslatedText(attr.getTextRegion());
                    Matcher matcher = AVAILABLE_UNAVAILABLE.matcher((CharSequence)text);
                    return matcher.matches();
                });
            }
        };
    }
}

