/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.sourceforge.pmd.lang.plsql.ast.ASTName;
import net.sourceforge.pmd.lang.plsql.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.plsql.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractScope;
import net.sourceforge.pmd.lang.symboltable.Applier;
import net.sourceforge.pmd.lang.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScope
extends AbstractScope {
    private static final Logger LOG = LoggerFactory.getLogger(ClassScope.class);
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;

    public ClassScope(String className) {
        this.className = PLSQLNode.getCanonicalImage(className);
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    public void addDeclaration(NameDeclaration declaration) {
        if (declaration instanceof VariableNameDeclaration && this.getDeclarations().keySet().contains(declaration)) {
            throw new RuntimeException(declaration + " is already in the symbol table");
        }
        super.addDeclaration(declaration);
    }

    public Set<NameDeclaration> addNameOccurrence(NameOccurrence occ) {
        Set<NameDeclaration> declarations;
        block3: {
            PLSQLNameOccurrence occurrence;
            block2: {
                occurrence = (PLSQLNameOccurrence)occ;
                declarations = this.findVariableHere(occurrence);
                Map<MethodNameDeclaration, List<NameOccurrence>> methodNames = this.getMethodDeclarations();
                if (declarations.isEmpty() || !occurrence.isMethodOrConstructorInvocation()) break block2;
                for (NameDeclaration decl : declarations) {
                    List<NameOccurrence> nameOccurrences = methodNames.get(decl);
                    if (nameOccurrences == null) continue;
                    nameOccurrences.add(occurrence);
                    PLSQLNode n = occurrence.getLocation();
                    if (!(n instanceof ASTName)) continue;
                    InternalApiBridge.setNameDeclaration((ASTName)n, decl);
                }
                break block3;
            }
            if (declarations.isEmpty() || occurrence.isThisOrSuper()) break block3;
            Map<VariableNameDeclaration, List<NameOccurrence>> variableNames = this.getVariableDeclarations();
            for (NameDeclaration decl : declarations) {
                List<NameOccurrence> nameOccurrences = variableNames.get(decl);
                if (nameOccurrences == null) continue;
                nameOccurrences.add(occurrence);
                PLSQLNode n = occurrence.getLocation();
                if (!(n instanceof ASTName)) continue;
                InternalApiBridge.setNameDeclaration((ASTName)n, decl);
            }
        }
        return declarations;
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.getDeclarations(MethodNameDeclaration.class);
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public ClassScope getEnclosingClassScope() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    protected Set<NameDeclaration> findVariableHere(PLSQLNameOccurrence occurrence) {
        HashSet<NameDeclaration> result = new HashSet<NameDeclaration>();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations = this.getVariableDeclarations();
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations = this.getMethodDeclarations();
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (variableDeclarations.isEmpty() && methodDeclarations.isEmpty()) {
                return result;
            }
            if (!variableDeclarations.isEmpty()) {
                result.add((NameDeclaration)variableDeclarations.keySet().iterator().next());
                return result;
            }
            result.add((NameDeclaration)methodDeclarations.keySet().iterator().next());
            return result;
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                int args;
                if (!mnd.getImage().equals(occurrence.getImage()) || (args = occurrence.getArgumentCount()) != mnd.getParameterCount() && (!mnd.isVarargs() || args < mnd.getParameterCount() - 1)) continue;
                result.add((NameDeclaration)mnd);
            }
            return result;
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (null == occurrence.getImage()) {
            LOG.trace("occurrence=={} with Argument Count == {} for className={}", new Object[]{occurrence.toString(), occurrence.getArgumentCount(), this.className});
        }
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply((Predicate)finder, this.getVariableDeclarations().keySet().iterator());
        if (finder.getDecl() != null) {
            result.add(finder.getDecl());
        }
        return result;
    }

    public String toString() {
        StringBuilder res = new StringBuilder("ClassScope (").append(this.className).append("): ");
        Map<ClassNameDeclaration, List<NameOccurrence>> classNames = this.getClassDeclarations();
        Map<MethodNameDeclaration, List<NameOccurrence>> methodNames = this.getMethodDeclarations();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableNames = this.getVariableDeclarations();
        if (!classNames.isEmpty()) {
            res.append('(').append(classNames.keySet()).append(')');
        }
        if (!methodNames.isEmpty()) {
            for (MethodNameDeclaration mnd : methodNames.keySet()) {
                res.append(mnd.toString());
                int usages = methodNames.get((Object)mnd).size();
                res.append("(begins at line ").append(mnd.getNode().getBeginLine()).append(", ").append(usages).append(" usages)");
                res.append(',');
            }
        }
        if (!variableNames.isEmpty()) {
            res.append('(').append(variableNames.keySet()).append(')');
        }
        return res.toString();
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

