/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BaseExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BasePolyMirror<T extends JavaNode>
extends BaseExprMirror<T>
implements ExprMirror.PolyExprMirror {
    private final JavaExprMirrors.MirrorMaker subexprMaker;
    private JTypeMirror inferredType;

    BasePolyMirror(JavaExprMirrors mirrors, T myNode, @Nullable ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, myNode, parent);
        this.subexprMaker = subexprMaker;
    }

    protected ExprMirror createSubexpression(ASTExpression subexpr) {
        return this.subexprMaker.createMirrorForSubexpression(subexpr, this, this.subexprMaker);
    }

    @Override
    public void setInferredType(JTypeMirror mirror) {
        this.inferredType = mirror;
        if (this.myNode instanceof TypeNode && this.mayMutateAst()) {
            InternalApiBridge.setTypeMirrorInternal((TypeNode)this.myNode, mirror);
        }
    }

    @Override
    public JTypeMirror getInferredType() {
        return this.inferredType;
    }

    @Override
    public @NonNull JClassType getEnclosingType() {
        return this.myNode.getEnclosingType().getTypeMirror();
    }
}

