/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.MapFunction;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypingContext
extends MapFunction<JVariableSymbol, JTypeMirror> {
    public static final TypingContext DEFAULT = new TypingContext(null, Collections.emptyMap());
    private final @Nullable TypingContext parent;

    private TypingContext(@Nullable TypingContext parent, Map<JVariableSymbol, @Nullable JTypeMirror> map) {
        super(map);
        this.parent = parent;
    }

    @Override
    public @Nullable JTypeMirror apply(JVariableSymbol var) {
        JTypeMirror t = (JTypeMirror)this.getMap().get(var);
        if (t == null && this.parent != null) {
            return this.parent.apply(var);
        }
        return t;
    }

    public TypingContext andThen(Map<JVariableSymbol, @Nullable JTypeMirror> map) {
        return new TypingContext(this, map);
    }

    public TypingContext andThenZip(List<JVariableSymbol> symbols, List<? extends JTypeMirror> types) {
        AssertionUtil.requireParamNotNull((String)"symbols", symbols);
        AssertionUtil.requireParamNotNull((String)"types", types);
        if (symbols.size() != types.size()) {
            throw new IllegalArgumentException("Wrong size");
        }
        if (symbols.isEmpty()) {
            return this;
        }
        HashMap<JVariableSymbol, JTypeMirror> newMap = new HashMap<JVariableSymbol, JTypeMirror>(symbols.size() + this.getMap().size());
        newMap.putAll(this.getMap());
        for (int i = 0; i < symbols.size(); ++i) {
            newMap.put(symbols.get(i), types.get(i));
        }
        return this.andThen(newMap);
    }

    public static TypingContext zip(List<JVariableSymbol> symbols, List<JTypeMirror> types) {
        return DEFAULT.andThenZip(symbols, types);
    }
}

