/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

public interface JTypeVar
extends SubstVar {
    @Override
    public @Nullable JTypeParameterSymbol getSymbol();

    public @NonNull String getName();

    public @NonNull JTypeMirror getUpperBound();

    public @NonNull JTypeMirror getLowerBound();

    public boolean isCaptured();

    public boolean isCaptureOf(JWildcardType var1);

    public @Nullable JWildcardType getCapturedOrigin();

    @Override
    default public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitTypeVar(this, p);
    }

    public JTypeVar substInBounds(Function<? super SubstVar, ? extends @NonNull JTypeMirror> var1);

    public JTypeVar cloneWithBounds(JTypeMirror var1, JTypeMirror var2);

    @Deprecated
    public JTypeVar withUpperBound(@NonNull JTypeMirror var1);

    @Override
    public JTypeVar withAnnotations(PSet<SymbolicValue.SymAnnot> var1);

    @Override
    default public JTypeVar addAnnotation(@NonNull SymbolicValue.SymAnnot newAnnot) {
        return this.withAnnotations(this.getTypeAnnotations().plus((Object)Objects.requireNonNull(newAnnot)));
    }

    @Override
    default public Stream<JMethodSig> streamMethods(Predicate<? super JMethodSymbol> prefilter) {
        return this.getUpperBound().streamMethods(prefilter);
    }
}

