/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ArrayMethodSigImpl
implements JMethodSig,
InternalMethodTypeItf {
    private final JArrayType owner;
    private final JExecutableSymbol symbol;

    ArrayMethodSigImpl(JArrayType owner, @NonNull JExecutableSymbol symbol) {
        this.owner = owner;
        this.symbol = symbol;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.owner.getTypeSystem();
    }

    @Override
    public JExecutableSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public JArrayType getDeclaringType() {
        return this.owner;
    }

    @Override
    public JMethodSig getErasure() {
        JArrayType erasedOwner = this.owner.getErasure();
        return erasedOwner == this.owner ? this : new ArrayMethodSigImpl(erasedOwner, this.symbol);
    }

    @Override
    public JTypeMirror getAnnotatedReceiverType() {
        return this.owner;
    }

    @Override
    public JTypeMirror getReturnType() {
        return this.owner;
    }

    @Override
    public List<JTypeMirror> getFormalParameters() {
        if (this.getSymbol() instanceof JConstructorSymbol) {
            return Collections.singletonList(this.owner.getTypeSystem().INT);
        }
        return Collections.emptyList();
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public List<JTypeMirror> getThrownExceptions() {
        return Collections.emptyList();
    }

    @Override
    public JMethodSig withReturnType(JTypeMirror returnType) {
        if (!returnType.equals(this.owner)) {
            throw new UnsupportedOperationException("Something went wrong");
        }
        return this;
    }

    @Override
    public JMethodSig withTypeParams(@Nullable List<JTypeVar> tparams) {
        if (tparams != null && !tparams.isEmpty()) {
            throw new UnsupportedOperationException("Something went wrong");
        }
        return this;
    }

    @Override
    public JMethodSig subst(Function<? super SubstVar, ? extends JTypeMirror> fun) {
        JArrayType subbed = (JArrayType)TypeOps.subst(this.owner, fun);
        return new ArrayMethodSigImpl(subbed, this.getSymbol());
    }

    @Override
    public JMethodSig withOwner(JTypeMirror newOwner) {
        if (newOwner instanceof JArrayType) {
            return new ArrayMethodSigImpl((JArrayType)newOwner, this.symbol);
        }
        throw new IllegalArgumentException(newOwner + " cannot be the owner of " + this);
    }

    @Override
    public JMethodSig markAsAdapted() {
        return this;
    }

    @Override
    public JMethodSig originalMethod() {
        return new ArrayMethodSigImpl(this.owner, this.symbol);
    }

    @Override
    public JMethodSig adaptedMethod() {
        return this.originalMethod();
    }

    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JMethodSig)) {
            return false;
        }
        JMethodSig that = (JMethodSig)o;
        return TypeOps.isSameType(this, that);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getFormalParameters(), this.getReturnType());
    }
}

