/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols;

import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.Substitution;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface JExecutableSymbol
extends JTypeParameterOwnerSymbol {
    public List<JFormalParamSymbol> getFormalParameters();

    default public JTypeMirror getReturnType(Substitution subst) {
        throw new UnsupportedOperationException("Default method was added for compatibility, will be removed");
    }

    default public boolean isDefaultMethod() {
        return this instanceof JMethodSymbol && (this.getModifiers() & 0x409) == 1 && this.getEnclosingClass().isInterface();
    }

    public boolean isVarargs();

    public int getArity();

    public @Nullable JTypeMirror getAnnotatedReceiverType(Substitution var1);

    default public boolean hasReceiver() {
        if (this.isStatic()) {
            return false;
        }
        if (this instanceof JConstructorSymbol) {
            return !this.getEnclosingClass().isStatic() && this.getEnclosingClass().getEnclosingClass() != null;
        }
        return true;
    }

    @Override
    public @NonNull JClassSymbol getEnclosingClass();

    @Override
    default public @NonNull String getPackageName() {
        return this.getEnclosingClass().getPackageName();
    }

    public List<JTypeMirror> getFormalParameterTypes(Substitution var1);

    public List<JTypeMirror> getThrownExceptionTypes(Substitution var1);

    default public JMethodSig getGenericSignature() {
        return this.getTypeSystem().sigOf(this);
    }
}

