/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.Optional;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionException;

public final class MetricFunction
extends BaseJavaXPathFunction {
    public static final MetricFunction INSTANCE = new MetricFunction();

    private MetricFunction() {
        super("metric");
    }

    public XPathFunctionDefinition.Type[] getArgumentTypes() {
        return new XPathFunctionDefinition.Type[]{XPathFunctionDefinition.Type.SINGLE_STRING};
    }

    public XPathFunctionDefinition.Type getResultType() {
        return XPathFunctionDefinition.Type.OPTIONAL_DECIMAL;
    }

    public boolean dependsOnContext() {
        return true;
    }

    public XPathFunctionDefinition.FunctionCall makeCallExpression() {
        return (contextNode, arguments) -> {
            String metricKey = arguments[0].toString();
            return MetricFunction.getMetric(contextNode, metricKey);
        };
    }

    static String badMetricKeyMessage(String constantName) {
        return String.format("'%s' is not the name of a metric", constantName);
    }

    private static Optional<Double> getMetric(Node n, String metricKeyName) throws XPathFunctionException {
        LanguageMetricsProvider provider = n.getAstInfo().getLanguageProcessor().services().getLanguageMetricsProvider();
        Metric metric = provider.getMetricWithName(metricKeyName);
        if (metric == null) {
            throw new XPathFunctionException(MetricFunction.badMetricKeyMessage(metricKeyName));
        }
        Number computed = Metric.compute((Metric)metric, (Node)n, (MetricOptions)MetricOptions.emptyOptions());
        return computed == null ? Optional.empty() : Optional.of(computed.doubleValue());
    }
}

