/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.List;
import java.util.Optional;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;

public class GetCommentOnFunction
extends BaseJavaXPathFunction {
    public static final GetCommentOnFunction INSTANCE = new GetCommentOnFunction();

    protected GetCommentOnFunction() {
        super("getCommentOn");
    }

    public XPathFunctionDefinition.Type getResultType() {
        return XPathFunctionDefinition.Type.OPTIONAL_STRING;
    }

    public boolean dependsOnContext() {
        return true;
    }

    public XPathFunctionDefinition.FunctionCall makeCallExpression() {
        return (contextNode, arguments) -> {
            int codeBeginLine = contextNode.getBeginLine();
            int codeEndLine = contextNode.getEndLine();
            List<JavaComment> commentList = ((ASTCompilationUnit)contextNode.ancestorsOrSelf().filterIs(ASTCompilationUnit.class).first()).getComments();
            for (JavaComment comment : commentList) {
                FileLocation location = comment.getReportLocation();
                if (location.getStartLine() != codeBeginLine && location.getEndLine() != codeEndLine) continue;
                return Optional.of(comment.getText().toString());
            }
            return Optional.empty();
        };
    }
}

