/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.security;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

abstract class AbstractHardCodedConstructorArgsVisitor
extends AbstractJavaRulechainRule {
    private final Class<?> type;

    AbstractHardCodedConstructorArgsVisitor(Class<?> constructorType) {
        super(ASTConstructorCall.class, new Class[0]);
        this.type = constructorType;
    }

    public Object visit(ASTConstructorCall node, Object data) {
        ASTArgumentList arguments;
        if (TypeTestUtil.isA(this.type, (TypeNode)node) && (arguments = node.getArguments()).size() > 0) {
            this.validateProperKeyArgument(data, (ASTExpression)arguments.get(0));
        }
        return data;
    }

    private void validateProperKeyArgument(Object data, ASTExpression firstArgumentExpression) {
        if (firstArgumentExpression == null) {
            return;
        }
        ASTVariableAccess varAccess = null;
        if (firstArgumentExpression instanceof ASTMethodCall) {
            ASTExpression expr = ((ASTMethodCall)firstArgumentExpression).getQualifier();
            if (expr instanceof ASTVariableAccess) {
                varAccess = (ASTVariableAccess)expr;
            }
        } else if (firstArgumentExpression instanceof ASTVariableAccess) {
            varAccess = (ASTVariableAccess)firstArgumentExpression;
        }
        if (varAccess != null && varAccess.getSignature() != null && varAccess.getSignature().getSymbol() != null) {
            ASTVariableId varDecl = (ASTVariableId)varAccess.getSignature().getSymbol().tryGetNode();
            this.validateProperKeyArgument(data, varDecl.getInitializer());
            this.validateVarUsages(data, varDecl);
        } else if (firstArgumentExpression instanceof ASTArrayAllocation) {
            ASTArrayInitializer arrayInit = ((ASTArrayAllocation)firstArgumentExpression).getArrayInitializer();
            if (arrayInit != null) {
                this.asCtx(data).addViolation((Node)arrayInit);
            }
        } else {
            ASTStringLiteral literal = (ASTStringLiteral)firstArgumentExpression.descendantsOrSelf().filterIs(ASTStringLiteral.class).first();
            if (literal != null) {
                this.asCtx(data).addViolation((Node)literal);
            }
        }
    }

    private void validateVarUsages(Object data, ASTVariableId varDecl) {
        varDecl.getLocalUsages().stream().filter(u -> u.getAccessType() == ASTAssignableExpr.AccessType.WRITE).filter(u -> u.getParent() instanceof ASTAssignmentExpression).forEach(usage -> {
            ASTAssignmentExpression assignment = (ASTAssignmentExpression)usage.getParent();
            this.validateProperKeyArgument(data, assignment.getRightOperand());
        });
    }
}

