/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ModifierOwner
extends Annotatable {
    @Override
    default public NodeStream<ASTAnnotation> getDeclaredAnnotations() {
        return this.getModifiers().children(ASTAnnotation.class);
    }

    default public @NonNull ASTModifierList getModifiers() {
        return (ASTModifierList)this.firstChild(ASTModifierList.class);
    }

    default public Visibility getVisibility() {
        Set<JModifier> effective = this.getModifiers().getEffectiveModifiers();
        if (effective.contains((Object)JModifier.PUBLIC)) {
            return Visibility.V_PUBLIC;
        }
        if (effective.contains((Object)JModifier.PROTECTED)) {
            return Visibility.V_PROTECTED;
        }
        if (effective.contains((Object)JModifier.PRIVATE)) {
            return Visibility.V_PRIVATE;
        }
        return Visibility.V_PACKAGE;
    }

    default public Visibility getEffectiveVisibility() {
        Visibility minv = this.getVisibility();
        if (minv == Visibility.V_LOCAL) {
            return minv;
        }
        for (ASTTypeDeclaration enclosing : this.ancestors(ASTTypeDeclaration.class)) {
            if ((minv = Visibility.min(minv, enclosing.getVisibility())) != Visibility.V_LOCAL) continue;
            return minv;
        }
        return minv;
    }

    default public boolean hasModifiers(JModifier mod1, JModifier ... mod) {
        return this.getModifiers().hasAll(mod1, mod);
    }

    default public boolean hasExplicitModifiers(JModifier mod1, JModifier ... mod) {
        return this.getModifiers().hasAllExplicitly(mod1, mod);
    }

    default public boolean hasVisibility(Visibility visibility) {
        return this.getVisibility() == visibility;
    }

    public static enum Visibility {
        V_ANONYMOUS("anonymous"),
        V_LOCAL("local"),
        V_PRIVATE("private"),
        V_PACKAGE("package"),
        V_PROTECTED("protected"),
        V_PUBLIC("public");

        private final String myName;

        private Visibility(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        public boolean isAtLeast(Visibility other) {
            return this.compareTo(other) >= 0;
        }

        public boolean isAtMost(Visibility other) {
            return this.compareTo(other) <= 0;
        }

        static Visibility min(Visibility v1, Visibility v2) {
            return v1.compareTo(v2) <= 0 ? v1 : v2;
        }
    }
}

