/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.lang.java.types.internal.infer.Graph;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.util.IteratorUtil;

interface VarWalkStrategy
extends Iterator<Set<InferenceVar>> {
    @Override
    public Set<InferenceVar> next();

    @Override
    public boolean hasNext();

    public static class GraphWalk
    implements VarWalkStrategy {
        private final Iterator<Set<InferenceVar>> iterator;

        GraphWalk(InferenceContext infCtx, boolean onlyBoundedVars) {
            this.iterator = this.buildGraphIterator(infCtx, onlyBoundedVars);
        }

        GraphWalk(InferenceVar var) {
            this.iterator = IteratorUtil.singletonIterator(Collections.singleton(var));
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Set<InferenceVar> next() {
            return this.iterator.next();
        }

        Iterator<Set<InferenceVar>> buildGraphIterator(InferenceContext ctx, boolean onlyBoundedVars) {
            Set<InferenceVar> freeVars = ctx.getFreeVars();
            if (freeVars.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (freeVars.size() == 1) {
                if (onlyBoundedVars && freeVars.iterator().next().hasOnlyPrimaryBound()) {
                    return Collections.emptyIterator();
                }
                return IteratorUtil.singletonIterator(freeVars);
            }
            Graph.UniqueGraph<InferenceVar> graph = new Graph.UniqueGraph<InferenceVar>();
            for (InferenceVar ivar : freeVars) {
                if (onlyBoundedVars && ivar.hasOnlyPrimaryBound()) continue;
                Graph.Vertex<InferenceVar> vertex = ((Graph)graph).addLeaf(ivar);
                Set<InferenceVar> dependencies = ctx.freeVarsIn(ivar.getBounds(InferenceVar.BoundKind.ALL));
                for (InferenceVar dep : dependencies) {
                    Graph.Vertex<InferenceVar> target = ((Graph)graph).addLeaf(dep);
                    graph.addEdge(vertex, target);
                }
            }
            graph.mergeCycles();
            if (graph.getVertices().size() == 1) {
                return IteratorUtil.singletonIterator(freeVars);
            }
            return graph.topologicalSort().iterator();
        }
    }
}

