/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.ast;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVoidType;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.java.types.TypesFromReflection;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.PolySite;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PolyResolution {
    private final Infer infer;
    private final TypeSystem ts;
    private final JavaExprMirrors exprMirrors;
    private final ExprContext booleanCtx;
    private final ExprContext stringCtx;
    private final ExprContext intCtx;

    PolyResolution(Infer infer) {
        this.infer = infer;
        this.ts = infer.getTypeSystem();
        this.exprMirrors = JavaExprMirrors.forTypeResolution(infer);
        this.stringCtx = PolyResolution.newStringCtx(this.ts);
        this.booleanCtx = PolyResolution.newNonPolyContext(this.ts.BOOLEAN);
        this.intCtx = PolyResolution.newNumericContext(this.ts.INT);
    }

    private boolean isPreJava8() {
        return this.infer.isPreJava8();
    }

    JTypeMirror computePolyType(TypeNode e) {
        if (!PolyResolution.canBePoly(e)) {
            throw AssertionUtil.shouldNotReachHere((String)("Unknown poly " + e));
        }
        ExprContext ctx = this.getTopLevelConversionContext(e);
        InvocationNode outerInvocNode = ctx.getInvocNodeIfInvocContext();
        if (outerInvocNode != null) {
            return this.polyTypeInvocationCtx(e, outerInvocNode);
        }
        return this.polyTypeOtherCtx(e, ctx);
    }

    private JTypeMirror polyTypeOtherCtx(TypeNode e, ExprContext ctx) {
        if (e instanceof InvocationNode) {
            JTypeMirror targetType = ctx.getPolyTargetType(false);
            return this.inferInvocation((InvocationNode)e, e, targetType);
        }
        if (e instanceof ASTSwitchExpression || e instanceof ASTConditionalExpression) {
            if (this.isPreJava8()) {
                ASTConditionalExpression conditional = (ASTConditionalExpression)e;
                return PolyResolution.computeStandaloneConditionalType(this.ts, conditional.getThenBranch().getTypeMirror(), conditional.getElseBranch().getTypeMirror());
            }
            JTypeMirror target = ctx.getPolyTargetType(false);
            if (target != null) {
                ExprMirror.BranchingMirror polyMirror = this.exprMirrors.getPolyBranchingMirror((ASTExpression)e);
                JTypeMirror standaloneType = polyMirror.getStandaloneType();
                if (standaloneType != null) {
                    polyMirror.setStandalone();
                    return standaloneType;
                }
                return target;
            }
            ExprMirror.BranchingMirror branchingMirror = this.exprMirrors.getStandaloneBranchingMirror((ASTExpression)e);
            branchingMirror.setStandalone();
            JTypeMirror standalone = branchingMirror.getStandaloneType();
            if (standalone != null) {
                return standalone;
            }
            if (!ctx.canGiveContextToPoly(false)) {
                if (e instanceof ASTSwitchExpression) {
                    List branches = ((ASTSwitchExpression)e).getYieldExpressions().toList(TypeNode::getTypeMirror);
                    return PolyResolution.computeStandaloneConditionalType(this.ts, branches);
                }
                throw AssertionUtil.shouldNotReachHere((String)"ConditionalMirrorImpl returns non-null for conditionals");
            }
            return this.ts.ERROR;
        }
        if (e instanceof ASTMethodReference || e instanceof ASTLambdaExpression) {
            JTypeMirror targetType = ctx.getPolyTargetType(true);
            return this.inferLambdaOrMref((ASTExpression)e, targetType);
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unknown poly " + e));
    }

    private JTypeMirror inferLambdaOrMref(ASTExpression e, @Nullable JTypeMirror targetType) {
        ExprMirror.FunctionalExprMirror mirror = this.exprMirrors.getTopLevelFunctionalMirror(e);
        PolySite<ExprMirror.FunctionalExprMirror> site = this.infer.newFunctionalSite(mirror, targetType);
        this.infer.inferFunctionalExprInUnambiguousContext(site);
        JTypeMirror result = InternalApiBridge.getTypeMirrorInternal(e);
        assert (result != null) : "Should be unknown";
        return result;
    }

    private @NonNull JTypeMirror polyTypeInvocationCtx(TypeNode e, InvocationNode ctxInvoc) {
        if (ctxInvoc instanceof ASTExpression) {
            ctxInvoc.getTypeMirror();
            return this.fetchCascaded(e);
        }
        return this.inferInvocation(ctxInvoc, e, null);
    }

    private JTypeMirror inferInvocation(InvocationNode ctxNode, TypeNode actualResultTarget, @Nullable JTypeMirror targetType) {
        ExprMirror.InvocationMirror mirror = this.exprMirrors.getTopLevelInvocationMirror(ctxNode);
        MethodCallSite site = this.infer.newCallSite(mirror, targetType);
        this.infer.inferInvocationRecursively(site);
        return this.fetchCascaded(actualResultTarget);
    }

    private @NonNull JTypeMirror fetchCascaded(TypeNode e) {
        InvocationNode parentInvoc;
        OverloadSelectionResult info;
        JTypeMirror type = InternalApiBridge.getTypeMirrorInternal(e);
        if (type != null) {
            return type;
        }
        if (((JavaNode)e.getParent()).getParent() instanceof InvocationNode && !(info = (parentInvoc = (InvocationNode)((JavaNode)e.getParent()).getParent()).getOverloadSelectionInfo()).isFailed()) {
            JTypeMirror targetT = info.ithFormalParam(e.getIndexInParent());
            if (e instanceof ASTLambdaExpression || e instanceof ASTMethodReference) {
                return this.inferLambdaOrMref((ASTExpression)e, targetT);
            }
            return targetT;
        }
        return this.fallbackIfCtxDidntSet(e);
    }

    private @NonNull JTypeMirror fallbackIfCtxDidntSet(@Nullable TypeNode e) {
        return this.polyTypeOtherCtx(e, ExprContext.getMissingInstance());
    }

    private static boolean canBePoly(TypeNode e) {
        return e instanceof ASTLambdaExpression || e instanceof ASTMethodReference || e instanceof ASTConditionalExpression || e instanceof ASTSwitchExpression || e instanceof InvocationNode;
    }

    JTypeMirror getContextTypeForStandaloneFallback(ASTExpression e) {
        JTypeMirror targetType;
        @NonNull ExprContext ctx = this.getTopLevelConversionContext(e);
        if (e.getParent() instanceof ASTSwitchLabel) {
            ASTSwitchLike switchLike = (ASTSwitchLike)e.ancestors(ASTSwitchLike.class).firstOrThrow();
            return switchLike.getTestedExpression().getTypeMirror();
        }
        if (ctx instanceof ExprContext.RegularCtx && (targetType = ctx.getPolyTargetType(false)) != null) {
            return targetType;
        }
        return this.ts.UNKNOWN;
    }

    ExprContext getConversionContextForExternalUse(ASTExpression e) {
        return this.contextOf(e, false, false);
    }

    ExprContext getTopLevelConversionContext(TypeNode e) {
        return this.contextOf(e, false, true);
    }

    private static @Nullable JTypeMirror returnTargetType(ASTReturnStatement context) {
        Node methodDecl = context.ancestors().first(it -> it instanceof ASTMethodDeclaration || it instanceof ASTLambdaExpression || it instanceof ASTAnyTypeDeclaration);
        if (methodDecl == null || methodDecl instanceof ASTAnyTypeDeclaration) {
            return null;
        }
        if (methodDecl instanceof ASTLambdaExpression) {
            JMethodSig fun = ((ASTLambdaExpression)methodDecl).getFunctionalMethod();
            return fun == null ? null : fun.getReturnType();
        }
        @NonNull ASTType resultType = ((ASTMethodDeclaration)methodDecl).getResultTypeNode();
        return resultType instanceof ASTVoidType ? null : resultType.getTypeMirror();
    }

    private @NonNull ExprContext contextOf(JavaNode node, boolean onlyInvoc, boolean internalUse) {
        JavaNode papa = (JavaNode)node.getParent();
        if (papa instanceof ASTArgumentList) {
            InvocationNode papi = (InvocationNode)papa.getParent();
            if (papi instanceof ASTExplicitConstructorInvocation || papi instanceof ASTEnumConstant) {
                return ExprContext.newInvocContext(papi, node.getIndexInParent());
            }
            if (this.isPreJava8()) {
                return ExprContext.getMissingInstance();
            }
            ExprContext outerCtx = this.contextOf(papi, true, internalUse);
            return outerCtx.canGiveContextToPoly(false) ? outerCtx : ExprContext.newInvocContext(papi, node.getIndexInParent());
        }
        if (this.doesCascadesContext(papa, node, internalUse)) {
            return this.contextOf(papa, onlyInvoc, internalUse);
        }
        if (onlyInvoc) {
            return ExprContext.getMissingInstance();
        }
        if (papa instanceof ASTArrayInitializer) {
            JTypeMirror target = TypeOps.getArrayComponent(((ASTArrayInitializer)papa).getTypeMirror());
            return PolyResolution.newAssignmentCtx(target);
        }
        if (papa instanceof ASTCastExpression) {
            JTypeMirror target = ((ASTCastExpression)papa).getCastType().getTypeMirror();
            return PolyResolution.newCastCtx(target);
        }
        if (papa instanceof ASTAssignmentExpression && node.getIndexInParent() == 1) {
            JTypeMirror target = ((ASTAssignmentExpression)papa).getLeftOperand().getTypeMirror();
            return PolyResolution.newAssignmentCtx(target);
        }
        if (papa instanceof ASTReturnStatement) {
            return PolyResolution.newAssignmentCtx(PolyResolution.returnTargetType((ASTReturnStatement)papa));
        }
        if (papa instanceof ASTVariableDeclarator && !((ASTVariableDeclarator)papa).getVarId().isTypeInferred()) {
            return PolyResolution.newAssignmentCtx(((ASTVariableDeclarator)papa).getVarId().getTypeMirror());
        }
        if (papa instanceof ASTYieldStatement) {
            ASTSwitchExpression owner = ((ASTYieldStatement)papa).getYieldTarget();
            return this.contextOf(owner, false, internalUse);
        }
        if (node instanceof ASTExplicitConstructorInvocation && ((ASTExplicitConstructorInvocation)node).isSuper()) {
            return PolyResolution.newSuperCtorCtx(node.getEnclosingType().getTypeMirror().getSuperClass());
        }
        if (!internalUse) {
            return this.conversionContextOf(node, papa);
        }
        return ExprContext.getMissingInstance();
    }

    private ExprContext conversionContextOf(JavaNode node, JavaNode papa) {
        if (papa instanceof ASTArrayAccess && node.getIndexInParent() == 1) {
            return this.intCtx;
        }
        if (papa instanceof ASTAssertStatement) {
            return node.getIndexInParent() == 0 ? this.booleanCtx : this.stringCtx;
        }
        if (papa instanceof ASTIfStatement || papa instanceof ASTLoopStatement && !(papa instanceof ASTForeachStatement)) {
            return this.booleanCtx;
        }
        if (papa instanceof ASTConditionalExpression) {
            if (node.getIndexInParent() == 0) {
                return this.booleanCtx;
            }
            if (this.isPreJava8()) {
                return ExprContext.getMissingInstance();
            }
            assert (InternalApiBridge.isStandaloneInternal((ASTConditionalExpression)papa)) : "Expected standalone ternary, otherwise doesCascadeContext(..) would have returned true";
            return PolyResolution.newStandaloneTernaryCtx(((ASTConditionalExpression)papa).getTypeMirror());
        }
        if (papa instanceof ASTInfixExpression) {
            BinaryOp op = ((ASTInfixExpression)papa).getOperator();
            JTypeMirror nodeType = ((ASTExpression)node).getTypeMirror();
            JTypeMirror otherType = JavaAstUtils.getOtherOperandIfInInfixExpr(node).getTypeMirror();
            JTypeMirror ctxType = ((ASTInfixExpression)papa).getTypeMirror();
            switch (op) {
                case CONDITIONAL_OR: 
                case CONDITIONAL_AND: {
                    return this.booleanCtx;
                }
                case OR: 
                case XOR: 
                case AND: {
                    return ctxType == this.ts.BOOLEAN ? this.booleanCtx : PolyResolution.newNumericContext(ctxType);
                }
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    return node.getIndexInParent() == 1 ? this.intCtx : PolyResolution.newNumericContext(nodeType.unbox());
                }
                case EQ: 
                case NE: {
                    if (otherType.isPrimitive() != nodeType.isPrimitive()) {
                        return PolyResolution.newNonPolyContext(otherType.unbox());
                    }
                    return ExprContext.getMissingInstance();
                }
                case ADD: {
                    if (TypeTestUtil.isA(String.class, ctxType)) {
                        return this.stringCtx;
                    }
                }
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: {
                    return PolyResolution.newNumericContext(ctxType);
                }
                case LE: 
                case GE: 
                case GT: 
                case LT: {
                    return PolyResolution.newNumericContext(TypeConversion.binaryNumericPromotion(nodeType, otherType));
                }
            }
            return ExprContext.getMissingInstance();
        }
        return ExprContext.getMissingInstance();
    }

    private boolean doesCascadesContext(JavaNode node, JavaNode child, boolean internalUse) {
        if (child.getParent() != node) {
            return false;
        }
        if (this.isPreJava8()) {
            return false;
        }
        if (!internalUse && node instanceof ASTConditionalExpression && child.getIndexInParent() != 0) {
            ((ASTConditionalExpression)node).getTypeMirror();
            return !InternalApiBridge.isStandaloneInternal((ASTConditionalExpression)node);
        }
        return node instanceof ASTSwitchExpression && child.getIndexInParent() != 0 || node instanceof ASTSwitchArrowBranch || node instanceof ASTConditionalExpression && child.getIndexInParent() != 0 || node instanceof ASTLambdaExpression && child.getIndexInParent() == 1;
    }

    static JTypeMirror computeStandaloneConditionalType(TypeSystem ts, JTypeMirror t2, JTypeMirror t3) {
        return PolyResolution.computeStandaloneConditionalType(ts, Arrays.asList(t2, t3));
    }

    private static JTypeMirror computeStandaloneConditionalType(TypeSystem ts, List<JTypeMirror> branchTypes) {
        if (branchTypes.isEmpty()) {
            return ts.OBJECT;
        }
        JTypeMirror head = branchTypes.get(0);
        List<JTypeMirror> tail = branchTypes.subList(1, branchTypes.size());
        if (CollectionUtil.all(tail, head::equals)) {
            return head;
        }
        List unboxed = CollectionUtil.map(branchTypes, JTypeMirror::unbox);
        if (CollectionUtil.all((Iterable)unboxed, JTypeMirror::isPrimitive)) {
            for (JPrimitiveType a : ts.allPrimitives) {
                if (!CollectionUtil.all((Iterable)unboxed, it -> it.isConvertibleTo(a).bySubtyping())) continue;
                return a;
            }
        }
        List boxed = CollectionUtil.map(branchTypes, JTypeMirror::box);
        for (JTypeMirror a : boxed) {
            if (!CollectionUtil.all((Iterable)unboxed, it -> TypeConversion.isConvertibleUsingBoxing(it, a))) continue;
            return a;
        }
        return ts.lub(branchTypes);
    }

    static ExprContext newAssignmentCtx(JTypeMirror targetType) {
        if (targetType == null) {
            return ExprContext.getMissingInstance();
        }
        return ExprContext.newOtherContext(targetType, ExprContext.ExprContextKind.ASSIGNMENT);
    }

    static ExprContext newNonPolyContext(JTypeMirror targetType) {
        return ExprContext.newOtherContext(targetType, ExprContext.ExprContextKind.BOOLEAN);
    }

    static ExprContext newStringCtx(TypeSystem ts) {
        JClassType stringType = (JClassType)TypesFromReflection.fromReflect(String.class, ts);
        return ExprContext.newOtherContext(stringType, ExprContext.ExprContextKind.STRING);
    }

    static ExprContext newNumericContext(JTypeMirror targetType) {
        if (targetType.isPrimitive()) {
            assert (targetType.isNumeric()) : "Not a numeric type - " + targetType;
            return ExprContext.newOtherContext(targetType, ExprContext.ExprContextKind.NUMERIC);
        }
        return ExprContext.getMissingInstance();
    }

    static ExprContext newCastCtx(JTypeMirror targetType) {
        return ExprContext.newOtherContext(targetType, ExprContext.ExprContextKind.CAST);
    }

    static ExprContext newSuperCtorCtx(JTypeMirror superclassType) {
        return ExprContext.newOtherContext(superclassType, ExprContext.ExprContextKind.ASSIGNMENT);
    }

    static ExprContext newStandaloneTernaryCtx(JTypeMirror ternaryType) {
        return ExprContext.newOtherContext(ternaryType, ExprContext.ExprContextKind.TERNARY);
    }
}

