/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

final class WildcardTypeImpl
implements JWildcardType {
    private final JTypeMirror bound;
    private final boolean isUpperBound;
    private final TypeSystem ts;
    private final PSet<SymbolicValue.SymAnnot> typeAnnots;

    WildcardTypeImpl(TypeSystem ts, boolean isUpperBound, @Nullable JTypeMirror bound, PSet<SymbolicValue.SymAnnot> typeAnnots) {
        this.ts = ts;
        this.typeAnnots = typeAnnots;
        this.bound = bound != null ? bound : (isUpperBound ? ts.OBJECT : ts.NULL_TYPE);
        this.isUpperBound = isUpperBound;
    }

    @Override
    public JWildcardType subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        JTypeVisitable newBound = this.getBound().subst((Function)subst);
        return newBound == this.getBound() ? this : this.ts.wildcard(this.isUpperBound(), (JTypeMirror)newBound).withAnnotations((PSet)this.typeAnnots);
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return this.typeAnnots;
    }

    @Override
    public JWildcardType withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        if (newTypeAnnots.isEmpty() && !this.typeAnnots.isEmpty()) {
            return this.ts.wildcard(this.isUpperBound, this.bound);
        }
        if (!newTypeAnnots.isEmpty()) {
            return new WildcardTypeImpl(this.ts, this.isUpperBound(), this.bound, newTypeAnnots);
        }
        return this;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public @NonNull JTypeMirror getBound() {
        return this.bound;
    }

    @Override
    public boolean isUpperBound() {
        return this.isUpperBound;
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWildcardType)) {
            return false;
        }
        JWildcardType that = (JWildcardType)o;
        return this.isUpperBound == that.isUpperBound() && Objects.equals(this.bound, that.getBound());
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.isUpperBound);
    }
}

