/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.UnresolvedClassStore;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.LexicalScope;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.Typed;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypesFromReflection {
    private TypesFromReflection() {
    }

    public static JTypeMirror fromReflect(Typed<?> reflected, TypeSystem ts) {
        return TypesFromReflection.fromReflect(ts, reflected.getType(), LexicalScope.EMPTY, Substitution.EMPTY);
    }

    public static JTypeMirror fromReflect(Type reflected, TypeSystem ts) {
        return TypesFromReflection.fromReflect(ts, reflected, LexicalScope.EMPTY, Substitution.EMPTY);
    }

    public static @Nullable JTypeMirror fromReflect(TypeSystem ts, @NonNull Type reflected, LexicalScope lexicalScope, Substitution subst) {
        Objects.requireNonNull(reflected, "Null type");
        Objects.requireNonNull(ts, "Null type system");
        Objects.requireNonNull(lexicalScope, "Null lexical scope, use the empty scope");
        Objects.requireNonNull(subst, "Null substitution, use the empty subst");
        if (reflected instanceof Class) {
            return ts.rawType(ts.getClassSymbol((Class)reflected));
        }
        if (reflected instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)reflected;
            Class raw = (Class)parameterized.getRawType();
            JClassSymbol sym = ts.getClassSymbol(raw);
            if (sym == null) {
                return null;
            }
            Object[] typeArguments = parameterized.getActualTypeArguments();
            List mapped = CollectionUtil.map((Object[])typeArguments, a -> TypesFromReflection.fromReflect(ts, a, lexicalScope, subst));
            if (CollectionUtil.any((Iterable)mapped, Objects::isNull)) {
                return null;
            }
            Type ownerType = parameterized.getOwnerType();
            if (ownerType != null && !Modifier.isStatic(raw.getModifiers())) {
                JClassType owner = (JClassType)TypesFromReflection.fromReflect(ts, ownerType, lexicalScope, subst);
                if (owner == null) {
                    return null;
                }
                return owner.selectInner(sym, mapped);
            }
            return ts.parameterise(sym, mapped);
        }
        if (reflected instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)reflected;
            @Nullable JTypeVar mapped = lexicalScope.apply(typeVariable.getName());
            if (mapped == null) {
                throw new IllegalArgumentException("The lexical scope " + lexicalScope + " does not contain an entry for type variable " + typeVariable.getName() + " (declared on " + typeVariable.getGenericDeclaration() + ")");
            }
            return subst.apply(mapped);
        }
        if (reflected instanceof WildcardType) {
            Type[] lowerBounds = ((WildcardType)reflected).getLowerBounds();
            if (lowerBounds.length == 0) {
                return TypesFromReflection.makeWildcard(ts, true, ((WildcardType)reflected).getUpperBounds(), lexicalScope, subst);
            }
            return TypesFromReflection.makeWildcard(ts, false, lowerBounds, lexicalScope, subst);
        }
        if (reflected instanceof GenericArrayType) {
            JTypeMirror comp = TypesFromReflection.fromReflect(ts, ((GenericArrayType)reflected).getGenericComponentType(), lexicalScope, subst);
            if (comp == null) {
                return null;
            }
            return ts.arrayType(comp);
        }
        throw new IllegalStateException("Illegal type " + reflected.getClass() + " " + reflected.getTypeName());
    }

    private static JTypeMirror makeWildcard(TypeSystem ts, boolean isUpper, Type[] bounds, LexicalScope lexicalScope, Substitution subst) {
        ArrayList<JTypeMirror> boundsMapped = new ArrayList<JTypeMirror>(bounds.length);
        for (Type a : bounds) {
            JTypeMirror jTypeMirror = TypesFromReflection.fromReflect(ts, a, lexicalScope, subst);
            if (jTypeMirror == null) {
                return null;
            }
            boundsMapped.add(jTypeMirror);
        }
        return ts.wildcard(isUpper, ts.glb(boundsMapped));
    }

    public static @Nullable JTypeMirror loadType(TypeSystem ctr, String className) {
        return TypesFromReflection.loadType(ctr, className, null);
    }

    public static @Nullable JTypeMirror loadType(TypeSystem ctr, String className, UnresolvedClassStore unresolvedStore) {
        return TypesFromReflection.loadClassMaybeArray(ctr, StringUtils.deleteWhitespace((String)className), unresolvedStore);
    }

    public static @Nullable JClassSymbol loadSymbol(TypeSystem ctr, String className) {
        JTypeMirror type = TypesFromReflection.loadType(ctr, className);
        return type == null ? null : (JClassSymbol)type.getSymbol();
    }

    private static @Nullable JTypeMirror loadClassMaybeArray(TypeSystem ts, String className, @Nullable UnresolvedClassStore unresolvedClassStore) {
        Validate.notNull((Object)className, (String)"className must not be null.", (Object[])new Object[0]);
        if (className.endsWith("[]")) {
            int i;
            int dimension = 0;
            for (i = className.length(); i >= 2 && className.startsWith("[]", i - 2); i -= 2) {
                ++dimension;
            }
            TypesFromReflection.checkJavaIdent(className, i);
            String elementName = className.substring(0, i);
            JClassSymbol elementType = TypesFromReflection.getClassOrDefault(ts, unresolvedClassStore, elementName);
            if (elementType == null) {
                return null;
            }
            return ts.arrayType(ts.rawType(elementType), dimension);
        }
        TypesFromReflection.checkJavaIdent(className, className.length());
        return ts.rawType(TypesFromReflection.getClassOrDefault(ts, unresolvedClassStore, className));
    }

    private static JClassSymbol getClassOrDefault(TypeSystem ts, @Nullable UnresolvedClassStore unresolvedClassStore, String canonicalName) {
        JClassSymbol loaded = ts.getClassSymbolFromCanonicalName(canonicalName);
        if (loaded == null && unresolvedClassStore != null) {
            loaded = unresolvedClassStore.makeUnresolvedReference(canonicalName, 0);
        }
        return loaded;
    }

    private static IllegalArgumentException invalidClassName(String className) {
        return new IllegalArgumentException("Not a valid class name \"" + className + "\"");
    }

    private static void checkJavaIdent(String className, int endOffsetExclusive) {
        if (endOffsetExclusive <= 0 || !Character.isJavaIdentifierStart(className.charAt(0))) {
            throw TypesFromReflection.invalidClassName(className);
        }
        for (int i = 1; i < endOffsetExclusive; ++i) {
            char c = className.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            throw TypesFromReflection.invalidClassName(className);
        }
    }
}

