/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.OptionalBool;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InvocationMatcher {
    final @Nullable String expectedName;
    final @Nullable List<TypeMatcher> argMatchers;
    final TypeMatcher qualifierMatcher;

    InvocationMatcher(TypeMatcher qualifierMatcher, String expectedName, @Nullable List<TypeMatcher> argMatchers) {
        this.expectedName = "_".equals(expectedName) ? null : expectedName;
        this.argMatchers = argMatchers;
        this.qualifierMatcher = qualifierMatcher;
    }

    public boolean matchesCall(@Nullable JavaNode node) {
        return node instanceof InvocationNode && this.matchesCall((InvocationNode)node);
    }

    public boolean matchesCall(@Nullable InvocationNode node) {
        if (node == null) {
            return false;
        }
        if (this.expectedName != null && !node.getMethodName().equals(this.expectedName) || this.argMatchers != null && ASTList.sizeOrZero(node.getArguments()) != this.argMatchers.size()) {
            return false;
        }
        OverloadSelectionResult info = node.getOverloadSelectionInfo();
        return !info.isFailed() && this.matchQualifier(node) && this.argsMatchOverload(info.getMethodType());
    }

    private boolean matchQualifier(InvocationNode node) {
        ASTExpression qualifier;
        if (this.qualifierMatcher == TypeMatcher.ANY) {
            return true;
        }
        if (node instanceof ASTConstructorCall) {
            JTypeMirror newType = ((ASTConstructorCall)node).getTypeNode().getTypeMirror();
            return this.qualifierMatcher.matches(newType, true);
        }
        JMethodSig m = node.getMethodType();
        JTypeMirror qualType = node instanceof QualifiableExpression ? ((qualifier = ((QualifiableExpression)((Object)node)).getQualifier()) != null ? qualifier.getTypeMirror() : m.getDeclaringType()) : m.getDeclaringType();
        return this.qualifierMatcher.matches(qualType, m.isStatic());
    }

    private boolean argsMatchOverload(JMethodSig invoc) {
        if (this.argMatchers == null) {
            return true;
        }
        List<JTypeMirror> formals = invoc.getFormalParameters();
        if (invoc.getArity() != this.argMatchers.size()) {
            return false;
        }
        for (int i = 0; i < formals.size(); ++i) {
            if (this.argMatchers.get(i).matches(formals.get(i), true)) continue;
            return false;
        }
        return true;
    }

    public static CompoundInvocationMatcher parseAll(String first, String ... rest) {
        List matchers = CollectionUtil.map((Collection)CollectionUtil.listOf((Object)first, (Object[])rest), InvocationMatcher::parse);
        return new CompoundInvocationMatcher(matchers);
    }

    public static InvocationMatcher parse(String sig) {
        ArrayList<TypeMatcher> argMatchers;
        int i = InvocationMatcher.parseType(sig, 0);
        TypeMatcher qualifierMatcher = InvocationMatcher.newMatcher(sig.substring(0, i));
        int nameStart = i = InvocationMatcher.consumeChar(sig, i, '#');
        i = InvocationMatcher.parseSimpleName(sig, i);
        String methodName = sig.substring(nameStart, i);
        if (InvocationMatcher.isChar(sig, i = InvocationMatcher.consumeChar(sig, i, '('), ')')) {
            return new InvocationMatcher(qualifierMatcher, methodName, Collections.emptyList());
        }
        if (InvocationMatcher.isChar(sig, i, '_') && InvocationMatcher.isChar(sig, i + 1, '*') && InvocationMatcher.isChar(sig, i + 2, ')')) {
            argMatchers = null;
            i += 3;
        } else {
            argMatchers = new ArrayList<TypeMatcher>();
            i = InvocationMatcher.parseArgList(sig, i, argMatchers);
        }
        if (i != sig.length()) {
            throw new IllegalArgumentException("Not a valid signature " + sig);
        }
        return new InvocationMatcher(qualifierMatcher, methodName, argMatchers);
    }

    private static int parseSimpleName(String sig, int start) {
        int i;
        for (i = start; i < sig.length() && Character.isJavaIdentifierPart(sig.charAt(i)); ++i) {
        }
        if (i == start) {
            throw new IllegalArgumentException("Not a valid signature " + sig);
        }
        return i;
    }

    private static int parseArgList(String sig, int i, List<TypeMatcher> argMatchers) {
        while (i < sig.length()) {
            if (InvocationMatcher.isChar(sig, i = InvocationMatcher.parseType(sig, i, argMatchers), ')')) {
                return i + 1;
            }
            i = InvocationMatcher.consumeChar(sig, i, ',');
        }
        throw new IllegalArgumentException("Not a valid signature " + sig);
    }

    private static int consumeChar(String source, int i, char c) {
        if (InvocationMatcher.isChar(source, i, c)) {
            return i + 1;
        }
        throw InvocationMatcher.newParseException(source, i, "character '" + c + "'");
    }

    private static RuntimeException newParseException(String source, int i, String expectedWhat) {
        String indent = "    ";
        String message = "Expected " + expectedWhat + " at index " + i + ":\n";
        message = message + "    \"" + StringUtil.escapeJava((String)source) + "\"\n";
        message = message + "    " + StringUtils.repeat((char)' ', (int)(i + 1)) + '^' + "\n";
        return new IllegalArgumentException(message);
    }

    private static boolean isChar(String source, int i, char c) {
        return i < source.length() && source.charAt(i) == c;
    }

    private static int parseType(String source, int i, List<TypeMatcher> result) {
        int start = i;
        i = InvocationMatcher.parseType(source, i);
        result.add(InvocationMatcher.newMatcher(source.substring(start, i)));
        return i;
    }

    private static int parseType(String source, int i) {
        int start = i;
        while (i < source.length() && (Character.isJavaIdentifierPart(source.charAt(i)) || source.charAt(i) == '.')) {
            ++i;
        }
        if (i == start) {
            throw InvocationMatcher.newParseException(source, i, "type");
        }
        AssertionUtil.assertValidJavaBinaryName((CharSequence)source.substring(start, i));
        while (InvocationMatcher.isChar(source, i, '[')) {
            i = InvocationMatcher.consumeChar(source, i + 1, ']');
        }
        return i;
    }

    private static TypeMatcher newMatcher(String name) {
        return "_".equals(name) ? TypeMatcher.ANY : new TypeMatcher(name);
    }

    public static final class CompoundInvocationMatcher {
        private final List<InvocationMatcher> matchers;

        private CompoundInvocationMatcher(List<InvocationMatcher> matchers) {
            this.matchers = matchers;
        }

        public boolean anyMatch(InvocationNode node) {
            return CollectionUtil.any(this.matchers, it -> it.matchesCall(node));
        }

        public boolean anyMatch(JavaNode node) {
            return CollectionUtil.any(this.matchers, it -> it.matchesCall(node));
        }
    }

    private static final class TypeMatcher {
        public static final TypeMatcher ANY = new TypeMatcher(null);
        final @Nullable String name;

        private TypeMatcher(@Nullable String name) {
            this.name = name;
        }

        boolean matches(JTypeMirror type, boolean exact) {
            return this.name == null || (exact ? TypeTestUtil.isExactlyAOrAnon(this.name, type) == OptionalBool.YES : TypeTestUtil.isA(this.name, type));
        }
    }
}

