/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class Loader {
    Loader() {
    }

    abstract @Nullable InputStream getInputStream() throws IOException;

    static class UrlLoader
    extends Loader {
        private final @NonNull URL url;

        UrlLoader(@NonNull URL url) {
            assert (url != null) : "Null url";
            this.url = url;
        }

        @Override
        @Nullable InputStream getInputStream() throws IOException {
            return this.url.openStream();
        }

        public String toString() {
            return "(URL loader)";
        }
    }

    static class FailedLoader
    extends Loader {
        static final FailedLoader INSTANCE = new FailedLoader();

        FailedLoader() {
        }

        @Override
        @Nullable InputStream getInputStream() {
            return null;
        }

        public String toString() {
            return "(failed loader)";
        }
    }
}

