/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.net.URL;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface Classpath {
    public @Nullable URL findResource(String var1);

    default public Classpath exclude(Set<String> deletedEntries) {
        return resourcePath -> deletedEntries.contains(resourcePath) ? null : this.findResource(resourcePath);
    }

    default public Classpath delegateTo(Classpath c) {
        return path -> {
            URL p = this.findResource(path);
            if (p != null) {
                return p;
            }
            return c.findResource(path);
        };
    }

    public static Classpath forClassLoader(ClassLoader classLoader) {
        return classLoader::getResource;
    }

    public static Classpath contextClasspath() {
        return Classpath.forClassLoader(Thread.currentThread().getContextClassLoader());
    }
}

