/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;
import net.sourceforge.pmd.util.CollectionUtil;

public final class GetModifiersFun
extends BaseJavaXPathFunction {
    private static final SequenceType[] ARGTYPES = new SequenceType[0];
    private final boolean explicit;
    public static final GetModifiersFun GET_EFFECTIVE = new GetModifiersFun("modifiers", false);
    public static final GetModifiersFun GET_EXPLICIT = new GetModifiersFun("explicitModifiers", true);

    private GetModifiersFun(String localName, boolean explicit) {
        super(localName);
        this.explicit = explicit;
    }

    public SequenceType[] getArgumentTypes() {
        return ARGTYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.STRING_SEQUENCE;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) {
                Node contextNode = ((AstElementNode)context.getContextItem()).getUnderlyingNode();
                if (contextNode instanceof AccessNode) {
                    ASTModifierList modList = ((AccessNode)contextNode).getModifiers();
                    Set<JModifier> mods = GetModifiersFun.this.explicit ? modList.getExplicitModifiers() : modList.getEffectiveModifiers();
                    return new SequenceExtent(CollectionUtil.map(mods, mod -> new StringValue((CharSequence)mod.getToken())));
                }
                return EmptySequence.getInstance();
            }
        };
    }
}

