/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseContextNodeTestFun;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;

abstract class BaseRewrittenFunction<S, N extends Node>
extends BaseJavaXPathFunction {
    private final Class<N> contextNodeType;

    protected BaseRewrittenFunction(String localName, Class<N> contextNodeType) {
        super(localName);
        this.contextNodeType = contextNodeType;
    }

    public SequenceType[] getArgumentTypes() {
        return BaseContextNodeTestFun.SINGLE_STRING_SEQ;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    protected abstract S parseArgument(String var1) throws XPathException;

    protected abstract boolean matches(N var1, String var2, S var3, boolean var4) throws XPathException;

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){
            private S constantState;
            private boolean isConstant;

            public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
                Expression firstArg = arguments[0];
                if (firstArg instanceof StringLiteral) {
                    String name = ((StringLiteral)firstArg).getStringValue();
                    try {
                        this.constantState = BaseRewrittenFunction.this.parseArgument(name);
                    }
                    catch (XPathException e) {
                        e.setIsStaticError(true);
                        throw e;
                    }
                    this.isConstant = true;
                }
                return null;
            }

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                Node node = ((AstElementNode)context.getContextItem()).getUnderlyingNode();
                if (!BaseRewrittenFunction.this.contextNodeType.isInstance(node)) {
                    return BooleanValue.FALSE;
                }
                String arg = arguments[0].head().getStringValue();
                Object parsedArg = this.isConstant ? this.constantState : BaseRewrittenFunction.this.parseArgument(arg);
                return BooleanValue.get((boolean)BaseRewrittenFunction.this.matches(node, arg, parsedArg, this.isConstant));
            }
        };
    }
}

