/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.function.BiPredicate;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;

public class BaseContextNodeTestFun<T extends JavaNode>
extends BaseJavaXPathFunction {
    static final SequenceType[] SINGLE_STRING_SEQ = new SequenceType[]{SequenceType.SINGLE_STRING};
    private final Class<T> klass;
    private final BiPredicate<String, T> checker;
    public static final BaseJavaXPathFunction TYPE_IS_EXACTLY = new BaseContextNodeTestFun<TypeNode>(TypeNode.class, "typeIsExactly", TypeTestUtil::isExactlyA);
    public static final BaseJavaXPathFunction TYPE_IS = new BaseContextNodeTestFun<TypeNode>(TypeNode.class, "typeIs", TypeTestUtil::isA);
    public static final BaseJavaXPathFunction HAS_ANNOTATION = new BaseContextNodeTestFun<Annotatable>(Annotatable.class, "hasAnnotation", (name, node) -> node.isAnnotationPresent((String)name));

    protected BaseContextNodeTestFun(Class<T> klass, String localName, BiPredicate<String, T> checker) {
        super(localName);
        this.klass = klass;
        this.checker = checker;
    }

    public SequenceType[] getArgumentTypes() {
        return SINGLE_STRING_SEQ;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                Node contextNode = ((AstElementNode)context.getContextItem()).getUnderlyingNode();
                String fullTypeName = arguments[0].head().getStringValue();
                return BooleanValue.get((BaseContextNodeTestFun.this.klass.isInstance(contextNode) && BaseContextNodeTestFun.this.checker.test(fullTypeName, (JavaNode)contextNode) ? 1 : 0) != 0);
            }
        };
    }
}

