/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;

public class JUnitSpellingRule
extends AbstractJavaRulechainRule {
    public JUnitSpellingRule() {
        super(ASTClassOrInterfaceDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (TestFrameworksUtil.isJUnit3Class(node)) {
            node.getDeclarations(ASTMethodDeclaration.class).filter(this::isViolation).forEach(it -> this.addViolation(data, (Node)it));
        }
        return null;
    }

    private boolean isViolation(ASTMethodDeclaration method) {
        if (method.getArity() != 0) {
            return false;
        }
        String name = method.getName();
        return !"setUp".equals(name) && "setup".equalsIgnoreCase(name) || !"tearDown".equals(name) && "teardown".equalsIgnoreCase(name);
    }
}

