/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class AbstractClassWithoutAbstractMethodRule
extends AbstractJavaRulechainRule {
    public AbstractClassWithoutAbstractMethodRule() {
        super(ASTClassOrInterfaceDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface() || !node.isAbstract() || this.doesExtend(node) || this.doesImplement(node)) {
            return data;
        }
        if (node.getDeclarations(ASTMethodDeclaration.class).none(ASTMethodOrConstructorDeclaration::isAbstract)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean doesExtend(ASTClassOrInterfaceDeclaration node) {
        return node.getSuperClassTypeNode() != null;
    }

    private boolean doesImplement(ASTClassOrInterfaceDeclaration node) {
        return !node.getSuperInterfaceTypeNodes().isEmpty();
    }
}

