/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;

public class CognitiveComplexityVisitor
extends JavaVisitorBase<State, Void> {
    public static final CognitiveComplexityVisitor INSTANCE = new CognitiveComplexityVisitor();

    @Override
    public Void visit(ASTIfStatement node, State state) {
        boolean isNotElseIf = !(node.getParent() instanceof ASTIfStatement);
        node.getCondition().acceptVisitor(this, state);
        if (isNotElseIf) {
            state.structuralComplexity();
        }
        node.getThenBranch().acceptVisitor(this, state);
        if (isNotElseIf) {
            state.decreaseNestingLevel();
        }
        if (node.hasElse()) {
            state.hybridComplexity();
            node.getElseBranch().acceptVisitor(this, state);
            state.decreaseNestingLevel();
        }
        return null;
    }

    @Override
    public Void visit(ASTContinueStatement node, State state) {
        boolean hasLabel;
        boolean bl = hasLabel = node.getImage() != null;
        if (hasLabel) {
            state.fundamentalComplexity();
        }
        return (Void)this.visitChildren((Node)node, state);
    }

    @Override
    public Void visit(ASTBreakStatement node, State state) {
        boolean hasLabel;
        boolean bl = hasLabel = node.getImage() != null;
        if (hasLabel) {
            state.fundamentalComplexity();
        }
        return (Void)this.visitChildren((Node)node, state);
    }

    @Override
    public Void visit(ASTInfixExpression node, State state) {
        BinaryOp op = node.getOperator();
        if (op == BinaryOp.CONDITIONAL_AND) {
            state.booleanOperation(BooleanOp.AND);
        } else if (op == BinaryOp.CONDITIONAL_OR) {
            state.booleanOperation(BooleanOp.OR);
        }
        return (Void)this.visitChildren((Node)node, state);
    }

    @Override
    public Void visit(ASTUnaryExpression node, State state) {
        if (node.getOperator() == UnaryOp.NEGATION) {
            state.booleanOperation(null);
        }
        return (Void)this.visitChildren((Node)node, state);
    }

    @Override
    public Void visit(ASTBlock node, State state) {
        for (JavaNode child : node.children()) {
            state.booleanOperation(null);
            child.acceptVisitor(this, state);
        }
        return null;
    }

    @Override
    public Void visit(ASTMethodDeclaration node, State state) {
        state.pushMethod(node);
        this.visitChildren((Node)node, state);
        state.popMethod();
        return null;
    }

    @Override
    public Void visit(ASTMethodCall node, State state) {
        JExecutableSymbol calledSymbol = node.getOverloadSelectionInfo().getMethodType().getSymbol();
        if (calledSymbol instanceof JMethodSymbol) {
            state.callMethod((JMethodSymbol)calledSymbol);
        }
        return (Void)this.visitChildren((Node)node, state);
    }

    @Override
    public Void visit(ASTForStatement node, State state) {
        return this.structural(node, state);
    }

    @Override
    public Void visit(ASTForeachStatement node, State state) {
        return this.structural(node, state);
    }

    @Override
    public Void visit(ASTSwitchStatement node, State state) {
        return this.structural(node, state);
    }

    @Override
    public Void visit(ASTLambdaExpression node, State state) {
        return this.nonStructural(node, state);
    }

    @Override
    public Void visit(ASTClassOrInterfaceBody node, State state) {
        return this.nonStructural(node, state);
    }

    @Override
    public Void visit(ASTWhileStatement node, State state) {
        return this.structural(node, state);
    }

    @Override
    public Void visit(ASTCatchClause node, State state) {
        return this.structural(node, state);
    }

    @Override
    public Void visit(ASTDoStatement node, State state) {
        return this.structural(node, state);
    }

    @Override
    public Void visit(ASTConditionalExpression node, State state) {
        return this.structural(node, state);
    }

    private Void nonStructural(JavaNode node, State state) {
        state.increaseNestingLevel();
        this.visitChildren((Node)node, state);
        state.decreaseNestingLevel();
        return null;
    }

    private Void structural(JavaNode node, State state) {
        state.structuralComplexity();
        this.visitChildren((Node)node, state);
        state.decreaseNestingLevel();
        return null;
    }

    public static class State {
        private int complexity = 0;
        private int nestingLevel = 0;
        private BooleanOp currentBooleanOperation = null;
        private final Deque<ASTMethodDeclaration> methodStack = new ArrayDeque<ASTMethodDeclaration>();

        public State(JavaNode topNode) {
            topNode.ancestors().filterIs(ASTMethodDeclaration.class).forEach(this.methodStack::addLast);
        }

        public int getComplexity() {
            return this.complexity;
        }

        void hybridComplexity() {
            ++this.complexity;
            ++this.nestingLevel;
        }

        void fundamentalComplexity() {
            ++this.complexity;
        }

        void structuralComplexity() {
            ++this.complexity;
            this.complexity += this.nestingLevel;
            ++this.nestingLevel;
        }

        void increaseNestingLevel() {
            ++this.nestingLevel;
        }

        void decreaseNestingLevel() {
            --this.nestingLevel;
        }

        void booleanOperation(BooleanOp op) {
            if (this.currentBooleanOperation != op) {
                if (op != null) {
                    this.fundamentalComplexity();
                }
                this.currentBooleanOperation = op;
            }
        }

        void pushMethod(ASTMethodDeclaration calledMethod) {
            this.methodStack.push(calledMethod);
        }

        void popMethod() {
            this.methodStack.pop();
        }

        void callMethod(JMethodSymbol calledMethod) {
            ASTMethodDeclaration methodNode = (ASTMethodDeclaration)calledMethod.tryGetNode();
            if (methodNode != null && this.methodStack.contains(methodNode)) {
                this.fundamentalComplexity();
            }
        }

        public String toString() {
            return "State{complexity=" + this.complexity + ", nestingLevel=" + this.nestingLevel + ", currentBooleanOperation=" + (Object)((Object)this.currentBooleanOperation) + '}';
        }
    }

    public static enum BooleanOp {
        AND,
        OR;

    }
}

