/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ViolationSuppressor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValue;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.errorprone.ImplicitSwitchFallThroughRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AnnotationSuppressionUtil {
    private static final Set<String> UNUSED_RULES = new HashSet<String>(Arrays.asList("UnusedPrivateField", "UnusedLocalVariable", "UnusedPrivateMethod", "UnusedFormalParameter", "UnusedAssignment", "SingularField"));
    private static final Set<String> SERIAL_RULES = new HashSet<String>(Arrays.asList("BeanMembersShouldSerialize", "NonSerializableClass", "MissingSerialVersionUID"));
    static final ViolationSuppressor JAVA_ANNOT_SUPPRESSOR = new ViolationSuppressor(){

        public String getId() {
            return "@SuppressWarnings";
        }

        public Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            if (AnnotationSuppressionUtil.contextSuppresses(node, rv.getRule())) {
                return new Report.SuppressedViolation(rv, (ViolationSuppressor)this, null);
            }
            return null;
        }
    };
    static final List<ViolationSuppressor> ALL_JAVA_SUPPRESSORS = CollectionUtil.listOf((Object)JAVA_ANNOT_SUPPRESSOR, (Object[])new ViolationSuppressor[0]);

    private AnnotationSuppressionUtil() {
    }

    static boolean contextSuppresses(Node node, Rule rule) {
        boolean result = AnnotationSuppressionUtil.suppresses(node, rule);
        if (!result && node instanceof ASTCompilationUnit) {
            for (int i = 0; !result && i < node.getNumChildren(); ++i) {
                result = AnnotationSuppressionUtil.suppresses(node.getChild(i), rule);
            }
        }
        if (!result) {
            for (Node parent = node.getParent(); !result && parent != null; parent = parent.getParent()) {
                result = AnnotationSuppressionUtil.suppresses(parent, rule);
            }
        }
        return result;
    }

    private static boolean suppresses(Node node, Rule rule) {
        Annotatable suppressor = AnnotationSuppressionUtil.getSuppressor(node);
        return suppressor != null && AnnotationSuppressionUtil.hasSuppressWarningsAnnotationFor(suppressor, rule);
    }

    private static @Nullable Annotatable getSuppressor(Node node) {
        if (node instanceof ASTAnyTypeDeclaration || node instanceof ASTMethodOrConstructorDeclaration || node instanceof ASTLocalVariableDeclaration || node instanceof ASTFieldDeclaration || node instanceof ASTFormalParameter) {
            return (Annotatable)node;
        }
        return null;
    }

    private static boolean hasSuppressWarningsAnnotationFor(Annotatable node, Rule rule) {
        return node.getDeclaredAnnotations().any(it -> AnnotationSuppressionUtil.annotationSuppresses(it, rule));
    }

    private static boolean annotationSuppresses(ASTAnnotation annotation, Rule rule) {
        if (TypeTestUtil.isA(SuppressWarnings.class, (TypeNode)annotation)) {
            for (ASTMemberValue value : annotation.getFlatValue("value")) {
                String stringVal;
                Object constVal = value.getConstValue();
                if (!(constVal instanceof String) || !("PMD".equals(stringVal = (String)constVal) || ("PMD." + rule.getName()).equals(stringVal) || "all".equals(stringVal) || "serial".equals(stringVal) && SERIAL_RULES.contains(rule.getName()) || "unused".equals(stringVal) && UNUSED_RULES.contains(rule.getName())) && (!"fallthrough".equals(stringVal) || !(rule instanceof ImplicitSwitchFallThroughRule))) continue;
                return true;
            }
        }
        return false;
    }
}

