/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;

public final class ASTModifierList
extends AbstractJavaNode {
    static final Set<JModifier> JUST_FINAL = Collections.singleton(JModifier.FINAL);
    private Set<JModifier> explicitModifiers;
    private Set<JModifier> effectiveModifiers;

    ASTModifierList(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    void setDeclaredModifiers(Set<JModifier> explicit) {
        this.explicitModifiers = explicit;
    }

    public Set<JModifier> getExplicitModifiers() {
        assert (this.explicitModifiers != null) : "Parser should have set the explicit modifiers";
        return Collections.unmodifiableSet(this.explicitModifiers);
    }

    public Set<JModifier> getEffectiveModifiers() {
        assert (this.explicitModifiers != null) : "Parser should have set the explicit modifiers";
        if (this.effectiveModifiers == null) {
            EnumSet<JModifier> mods = this.explicitModifiers.isEmpty() ? EnumSet.noneOf(JModifier.class) : EnumSet.copyOf(this.explicitModifiers);
            this.getOwner().acceptVisitor(EffectiveModifierVisitor.INSTANCE, mods);
            this.effectiveModifiers = Collections.unmodifiableSet(mods);
        }
        return this.effectiveModifiers;
    }

    public Annotatable getOwner() {
        return (Annotatable)this.getParent();
    }

    public boolean hasAll(JModifier mod1, JModifier ... mods) {
        Set<JModifier> actual = this.getEffectiveModifiers();
        return actual.contains((Object)mod1) && (mods.length == 0 || actual.containsAll(Arrays.asList(mods)));
    }

    public boolean hasAllExplicitly(JModifier mod1, JModifier ... mods) {
        Set<JModifier> actual = this.getExplicitModifiers();
        return actual.contains((Object)mod1) && (mods.length == 0 || actual.containsAll(Arrays.asList(mods)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasAny(JModifier mod1, JModifier ... mods) {
        Set<JModifier> actual = this.getEffectiveModifiers();
        if (actual.contains((Object)mod1)) return true;
        if (!Arrays.stream(mods).anyMatch(actual::contains)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasAnyExplicitly(JModifier mod1, JModifier ... mods) {
        Set<JModifier> actual = this.getExplicitModifiers();
        if (actual.contains((Object)mod1)) return true;
        if (!Arrays.stream(mods).anyMatch(actual::contains)) return false;
        return true;
    }

    private static final class EffectiveModifierVisitor
    extends JavaVisitorBase<Set<JModifier>, Void> {
        private static final EffectiveModifierVisitor INSTANCE = new EffectiveModifierVisitor();

        private EffectiveModifierVisitor() {
        }

        @Override
        public Void visitJavaNode(JavaNode node, Set<JModifier> data) {
            return null;
        }

        @Override
        public Void visitTypeDecl(ASTAnyTypeDeclaration node, Set<JModifier> effective) {
            ASTAnyTypeDeclaration enclosing = node.getEnclosingType();
            if (enclosing != null && enclosing.isInterface()) {
                effective.add(JModifier.PUBLIC);
                effective.add(JModifier.STATIC);
            }
            if (node.isInterface() || node.isAnnotation()) {
                effective.add(JModifier.ABSTRACT);
                if (!node.isTopLevel()) {
                    effective.add(JModifier.STATIC);
                }
            } else if (!node.isTopLevel() && (node instanceof ASTEnumDeclaration || node instanceof ASTRecordDeclaration)) {
                effective.add(JModifier.STATIC);
            }
            if (node instanceof ASTEnumDeclaration && node.getEnumConstants().none(ASTEnumConstant::isAnonymousClass) || node instanceof ASTRecordDeclaration) {
                effective.add(JModifier.FINAL);
            }
            return null;
        }

        @Override
        public Void visit(ASTFieldDeclaration node, Set<JModifier> effective) {
            if (node.getEnclosingType().isInterface()) {
                effective.add(JModifier.PUBLIC);
                effective.add(JModifier.STATIC);
                effective.add(JModifier.FINAL);
            }
            return null;
        }

        @Override
        public Void visit(ASTLocalVariableDeclaration node, Set<JModifier> effective) {
            if (node.getParent() instanceof ASTResource) {
                effective.add(JModifier.FINAL);
            }
            return null;
        }

        @Override
        public Void visit(ASTEnumConstant node, Set<JModifier> effective) {
            effective.add(JModifier.PUBLIC);
            effective.add(JModifier.STATIC);
            effective.add(JModifier.FINAL);
            return null;
        }

        @Override
        public Void visit(ASTRecordComponent node, Set<JModifier> effective) {
            effective.add(JModifier.PRIVATE);
            effective.add(JModifier.FINAL);
            return null;
        }

        @Override
        public Void visit(ASTAnonymousClassDeclaration node, Set<JModifier> effective) {
            ASTBodyDeclaration enclosing = (ASTBodyDeclaration)node.ancestors(ASTBodyDeclaration.class).first();
            assert (enclosing != null && !(enclosing instanceof ASTAnyTypeDeclaration)) : "Weird position for an anonymous class " + enclosing;
            if (enclosing instanceof ASTEnumConstant) {
                effective.add(JModifier.STATIC);
            } else if (enclosing instanceof AccessNode && ((AccessNode)((Object)enclosing)).hasModifiers(JModifier.STATIC, new JModifier[0]) || enclosing instanceof ASTInitializer && ((ASTInitializer)enclosing).isStatic()) {
                effective.add(JModifier.STATIC);
            }
            return null;
        }

        @Override
        public Void visit(ASTConstructorDeclaration node, Set<JModifier> effective) {
            if (node.getEnclosingType().isEnum()) {
                effective.add(JModifier.PRIVATE);
            }
            return null;
        }

        @Override
        public Void visit(ASTMethodDeclaration node, Set<JModifier> effective) {
            if (node.getEnclosingType().isInterface()) {
                Set declared = node.getModifiers().explicitModifiers;
                if (!declared.contains((Object)JModifier.PRIVATE)) {
                    effective.add(JModifier.PUBLIC);
                }
                if (!declared.contains((Object)JModifier.DEFAULT) && !declared.contains((Object)JModifier.STATIC)) {
                    effective.add(JModifier.ABSTRACT);
                }
            }
            return null;
        }
    }
}

