/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimensions;
import net.sourceforge.pmd.lang.java.ast.ASTDefaultValue;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponentList;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AbstractMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AstImplUtil;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.TokenUtils;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.rule.xpath.DeprecatedAttribute;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTMethodDeclaration
extends AbstractMethodOrConstructorDeclaration<JMethodSymbol> {
    private JMethodSig overriddenMethod = null;

    ASTMethodDeclaration(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public boolean isOverridden() {
        return this.overriddenMethod != null;
    }

    public JMethodSig getOverriddenMethod() {
        return this.overriddenMethod;
    }

    void setOverriddenMethod(JMethodSig overriddenMethod) {
        this.overriddenMethod = overriddenMethod;
    }

    public FileLocation getReportLocation() {
        JavaccToken ident = TokenUtils.nthPrevious(this.getModifiers().getLastToken(), this.getFormalParameters().getFirstToken(), 1);
        return ident.getReportLocation();
    }

    @Deprecated
    @DeprecatedAttribute(replaceWith="@Name")
    public String getMethodName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getImage();
    }

    public @Nullable ASTRecordComponent getAccessedRecordComponent() {
        if (this.getArity() != 0) {
            return null;
        }
        ASTRecordComponentList components = this.getEnclosingType().getRecordComponents();
        if (components == null) {
            return null;
        }
        return (ASTRecordComponent)components.toStream().first(it -> it.getVarId().getName().equals(this.getName()));
    }

    public boolean isVoid() {
        return this.getResultTypeNode().isVoid();
    }

    public @Nullable ASTDefaultValue getDefaultClause() {
        return AstImplUtil.getChildAs(this, this.getNumChildren() - 1, ASTDefaultValue.class);
    }

    public @NonNull ASTType getResultTypeNode() {
        return (ASTType)this.firstChild(ASTType.class);
    }

    public @Nullable ASTArrayDimensions getExtraDimensions() {
        return (ASTArrayDimensions)this.children(ASTArrayDimensions.class).first();
    }

    public boolean isMainMethod() {
        return this.hasModifiers(JModifier.PUBLIC, new JModifier[]{JModifier.STATIC}) && "main".equals(this.getName()) && this.isVoid() && this.getArity() == 1 && TypeTestUtil.isExactlyA(String[].class, (TypeNode)this.getFormalParameters().get(0));
    }
}

