/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.html.cpd;

import java.io.IOException;
import java.io.UncheckedIOException;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.html.HtmlLanguageModule;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocument;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlTextNode;
import net.sourceforge.pmd.lang.html.ast.HtmlNode;
import net.sourceforge.pmd.lang.html.ast.HtmlParser;

public class HtmlCpdLexer
implements CpdLexer {
    public void tokenize(TextDocument document, TokenFactory tokens) {
        HtmlLanguageModule html = HtmlLanguageModule.getInstance();
        try (LanguageProcessor processor = html.createProcessor(html.newPropertyBundle());){
            Parser.ParserTask task = new Parser.ParserTask(document, SemanticErrorReporter.noop(), LanguageProcessorRegistry.singleton((LanguageProcessor)processor));
            HtmlParser parser = new HtmlParser();
            ASTHtmlDocument root = parser.parse(task);
            this.traverse(root, tokens);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void traverse(HtmlNode node, TokenFactory tokenEntries) {
        String image = node.getXPathNodeName();
        if (node instanceof ASTHtmlTextNode) {
            image = ((ASTHtmlTextNode)node).getWholeText();
        }
        tokenEntries.recordToken(image, node.getReportLocation());
        for (HtmlNode child : node.children()) {
            this.traverse(child, tokenEntries);
        }
    }
}

