/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.docs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.docs.FileWriter;
import net.sourceforge.pmd.docs.RuleSetUtils;
import net.sourceforge.pmd.lang.Language;
import org.apache.commons.lang3.SystemUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class SidebarGenerator {
    private static final String SIDEBAR_YML = "docs/_data/sidebars/pmd_sidebar.yml";
    private final FileWriter writer;
    private final Path sidebarPath;

    public SidebarGenerator(FileWriter writer, Path basePath) {
        this.writer = Objects.requireNonNull(writer, "A file writer must be provided");
        this.sidebarPath = Objects.requireNonNull(basePath, "A base directory must be provided").resolve(SIDEBAR_YML);
    }

    private Map<String, Object> extractRuleReference(Map<String, Object> sidebar) {
        List entries = (List)sidebar.get("entries");
        Map entry = (Map)entries.get(0);
        List folders = (List)entry.get("folders");
        return (Map)folders.get(3);
    }

    public void generateSidebar(Map<Language, List<RuleSet>> sortedRulesets) throws IOException {
        Map<String, Object> sidebar = this.loadSidebar();
        Map<String, Object> ruleReference = this.extractRuleReference(sidebar);
        ruleReference.put("folderitems", this.generateRuleReferenceSection(sortedRulesets));
        this.writeSidebar(sidebar);
    }

    List<Map<String, Object>> generateRuleReferenceSection(Map<Language, List<RuleSet>> sortedRulesets) {
        ArrayList<Map<String, Object>> newFolderItems = new ArrayList<Map<String, Object>>();
        for (Map.Entry<Language, List<RuleSet>> entry : sortedRulesets.entrySet()) {
            LinkedHashMap<String, Object> newFolderItem = new LinkedHashMap<String, Object>();
            newFolderItem.put("title", null);
            newFolderItem.put("output", "web, pdf");
            LinkedHashMap<String, Object> subfolder = new LinkedHashMap<String, Object>();
            newFolderItem.put("subfolders", Arrays.asList(subfolder));
            subfolder.put("title", entry.getKey().getName() + " Rules");
            subfolder.put("output", "web, pdf");
            ArrayList subfolderitems = new ArrayList();
            subfolder.put("subfolderitems", subfolderitems);
            LinkedHashMap<String, String> ruleIndexSubfolderItem = new LinkedHashMap<String, String>();
            ruleIndexSubfolderItem.put("title", "Index");
            ruleIndexSubfolderItem.put("output", "web, pdf");
            ruleIndexSubfolderItem.put("url", "/pmd_rules_" + entry.getKey().getTerseName() + ".html");
            subfolderitems.add(ruleIndexSubfolderItem);
            for (RuleSet ruleset : entry.getValue()) {
                LinkedHashMap<String, String> subfolderitem = new LinkedHashMap<String, String>();
                subfolderitem.put("title", ruleset.getName());
                subfolderitem.put("output", "web, pdf");
                subfolderitem.put("url", "/pmd_rules_" + entry.getKey().getTerseName() + "_" + RuleSetUtils.getRuleSetFilename(ruleset) + ".html");
                subfolderitems.add(subfolderitem);
            }
            newFolderItems.add(newFolderItem);
        }
        return newFolderItems;
    }

    public Map<String, Object> loadSidebar() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.sidebarPath, StandardCharsets.UTF_8);){
            Map sidebar;
            Yaml yaml = new Yaml();
            Map map = sidebar = (Map)yaml.load((Reader)reader);
            return map;
        }
    }

    public void writeSidebar(Map<String, Object> sidebar) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        if (SystemUtils.IS_OS_WINDOWS) {
            options.setLineBreak(DumperOptions.LineBreak.WIN);
        }
        Yaml yaml = new Yaml(options);
        this.writer.write(this.sidebarPath, Arrays.asList(yaml.dump(sidebar)));
        System.out.println("Generated " + this.sidebarPath);
    }
}

