/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.docs;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleReference;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class RuleSetUtils {
    private RuleSetUtils() {
    }

    public static String getRuleSetFilename(RuleSet ruleset) {
        return RuleSetUtils.getRuleSetFilename(ruleset.getFileName());
    }

    public static String getRuleSetFilename(String rulesetFileName) {
        return FilenameUtils.getBaseName((String)StringUtils.chomp((String)rulesetFileName));
    }

    public static boolean isRuleSetDeprecated(RuleSet ruleset) {
        boolean result = true;
        for (Rule rule : ruleset.getRules()) {
            if (rule instanceof RuleReference && rule.isDeprecated()) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String getRuleSetClasspath(RuleSet ruleset) {
        String RESOURCES_PATH = "/resources/";
        String filename = FilenameUtils.normalize((String)StringUtils.chomp((String)ruleset.getFileName()), (boolean)true);
        int startIndex = filename.lastIndexOf("/resources/");
        if (startIndex > -1) {
            return filename.substring(startIndex + "/resources/".length());
        }
        return filename;
    }

    public static Rule resolveRuleReferences(Rule rule) {
        Rule result = rule;
        Rule ref = rule;
        while (ref instanceof RuleReference) {
            result = ref;
            ref = ((RuleReference)ref).getRule();
        }
        return result;
    }
}

