/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.docs;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.docs.DefaultFileWriter;
import net.sourceforge.pmd.docs.RuleDocGenerator;
import org.apache.commons.io.FilenameUtils;

public final class GenerateRuleDocsCmd {
    private GenerateRuleDocsCmd() {
    }

    public static void main(String[] args) throws RuleSetNotFoundException {
        long start = System.currentTimeMillis();
        Path output = FileSystems.getDefault().getPath(args[0], new String[0]).resolve("..").toAbsolutePath().normalize();
        System.out.println("Generating docs into " + output);
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        Iterator registeredRuleSets = ruleSetFactory.getRegisteredRuleSets();
        List<String> additionalRulesets = GenerateRuleDocsCmd.findAdditionalRulesets(output);
        RuleDocGenerator generator = new RuleDocGenerator(new DefaultFileWriter(), output);
        generator.generate(registeredRuleSets, additionalRulesets);
        System.out.println("Generated docs in " + (System.currentTimeMillis() - start) + " ms");
    }

    public static List<String> findAdditionalRulesets(Path basePath) {
        try {
            final ArrayList<String> additionalRulesets = new ArrayList<String>();
            final Pattern rulesetPattern = Pattern.compile("^.+" + Pattern.quote(File.separator) + "pmd-\\w+" + Pattern.quote(FilenameUtils.normalize((String)"/src/main/resources/rulesets/")) + "\\w+" + Pattern.quote(File.separator) + "\\w+.xml$");
            Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (rulesetPattern.matcher(file.toString()).matches()) {
                        additionalRulesets.add(file.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return additionalRulesets;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

