/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GraphUtil {
    private GraphUtil() {
    }

    public static <V> String toDot(Collection<? extends V> vertices, Function<? super V, ? extends Collection<? extends V>> successorFun, Function<? super V, DotColor> colorFun, Function<? super V, String> labelFun) {
        StringBuilder sb = new StringBuilder("strict digraph {\n");
        HashMap ids = new HashMap();
        int i = 0;
        ArrayList<V> vertexList = new ArrayList<V>(vertices);
        vertexList.sort(Comparator.comparing(Object::toString));
        for (Object node : vertexList) {
            String id = "n" + i++;
            ids.put(node, id);
            sb.append(id).append(" [ shape=box, color=").append(colorFun.apply(node).toDot()).append(", label=\"").append(GraphUtil.escapeDotString(labelFun.apply(node))).append("\" ];\n");
        }
        ArrayList<String> edges = new ArrayList<String>();
        for (Object node : vertexList) {
            String id = (String)ids.get(node);
            for (V succ : successorFun.apply(node)) {
                String succId = (String)ids.get(succ);
                edges.add(id + " -> " + succId + ";\n");
            }
        }
        edges.sort(Comparator.naturalOrder());
        edges.forEach(sb::append);
        return sb.append('}').toString();
    }

    private static @NonNull String escapeDotString(String string) {
        return string.replaceAll("\\R", "\\\n").replaceAll("\"", "\\\"");
    }

    public static enum DotColor {
        GREEN,
        BLACK;


        String toDot() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

