/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.function.Consumer;
import net.sourceforge.pmd.util.AssertionUtil;

public abstract class BaseResultProducingCloseable<T>
implements AutoCloseable {
    private boolean closed;

    protected final void ensureOpen() {
        AssertionUtil.validateState(!this.closed, "Listener has been closed");
    }

    public final T getResult() {
        AssertionUtil.validateState(this.closed, "Cannot get result before listener is closed");
        return this.getResultImpl();
    }

    protected abstract T getResultImpl();

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.closeImpl();
        }
    }

    protected void closeImpl() {
    }

    public static <U, C extends BaseResultProducingCloseable<U>> U using(C closeable, Consumer<? super C> it) {
        try {
            it.accept(closeable);
        }
        finally {
            closeable.close();
        }
        return closeable.getResult();
    }
}

