/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.Comparator;
import java.util.Map;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.rule.Rule;

public interface RuleViolation {
    public static final Comparator<RuleViolation> DEFAULT_COMPARATOR = Comparator.comparing(RuleViolation::getFileId).thenComparingInt(RuleViolation::getBeginLine).thenComparingInt(RuleViolation::getBeginColumn).thenComparing(RuleViolation::getDescription, Comparator.nullsLast(Comparator.naturalOrder())).thenComparingInt(RuleViolation::getEndLine).thenComparingInt(RuleViolation::getEndColumn).thenComparing(rv -> rv.getRule().getName());
    public static final String CLASS_NAME = "className";
    public static final String VARIABLE_NAME = "variableName";
    public static final String METHOD_NAME = "methodName";
    public static final String PACKAGE_NAME = "packageName";

    public Rule getRule();

    public String getDescription();

    public FileLocation getLocation();

    default public FileId getFileId() {
        return this.getLocation().getFileId();
    }

    default public int getBeginLine() {
        return this.getLocation().getStartPos().getLine();
    }

    default public int getBeginColumn() {
        return this.getLocation().getStartPos().getColumn();
    }

    default public int getEndLine() {
        return this.getLocation().getEndPos().getLine();
    }

    default public int getEndColumn() {
        return this.getLocation().getEndPos().getColumn();
    }

    public Map<String, String> getAdditionalInfo();
}

