/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.internal.NodeFindingUtil;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.ParametricRuleViolation;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.reporting.ViolationDecorator;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RuleContext {
    private static final Object[] NO_ARGS = new Object[0];
    static final List<ViolationSuppressor> DEFAULT_SUPPRESSORS = CollectionUtil.listOf(ViolationSuppressor.NOPMD_COMMENT_SUPPRESSOR, ViolationSuppressor.REGEX_SUPPRESSOR, ViolationSuppressor.XPATH_SUPPRESSOR);
    private final FileAnalysisListener listener;
    private final Rule rule;

    RuleContext(FileAnalysisListener listener, Rule rule) {
        Objects.requireNonNull(listener, "Listener was null");
        Objects.requireNonNull(rule, "Rule was null");
        this.listener = listener;
        this.rule = rule;
    }

    Rule getRule() {
        return this.rule;
    }

    private String getDefaultMessage() {
        return this.rule.getMessage();
    }

    public void addViolation(Node location) {
        this.addViolationWithMessage(location, this.getDefaultMessage(), NO_ARGS);
    }

    public void addViolation(Node location, Object ... formatArgs) {
        this.addViolationWithMessage(location, this.getDefaultMessage(), formatArgs);
    }

    public void addViolationWithMessage(Node location, String message) {
        this.addViolationWithPosition(location, -1, -1, message, NO_ARGS);
    }

    public void addViolationWithMessage(Node location, String message, Object ... formatArgs) {
        this.addViolationWithPosition(location, -1, -1, message, formatArgs);
    }

    public void addViolationWithPosition(Node node, int beginLine, int endLine, String message, Object ... formatArgs) {
        FileLocation location = beginLine != -1 && endLine != -1 ? FileLocation.range(node.getTextDocument().getFileId(), TextRange2d.range2d(beginLine, 1, endLine, 1)) : node.getReportLocation();
        this.addViolationWithPosition((Reportable)node, node.getAstInfo(), location, message, formatArgs);
    }

    @Experimental
    public void addViolationWithPosition(Reportable reportable, AstInfo<?> astInfo, FileLocation location, String message, Object ... formatArgs) {
        Objects.requireNonNull(reportable, "Node was null");
        Objects.requireNonNull(message, "Message was null");
        Objects.requireNonNull(formatArgs, "Format arguments were null, use an empty array");
        Node suppressionNode = this.getNearestNode(reportable, astInfo);
        RuleViolation violation = this.createViolation(() -> location, astInfo, suppressionNode, message, formatArgs);
        Report.SuppressedViolation suppressed = RuleContext.suppressOrNull(suppressionNode, violation, astInfo);
        if (suppressed != null) {
            this.listener.onSuppressedRuleViolation(suppressed);
        } else {
            this.listener.onRuleViolation(violation);
        }
    }

    @Experimental
    public void addViolationNoSuppress(Reportable reportable, AstInfo<?> astInfo, String message, Object ... formatArgs) {
        Objects.requireNonNull(reportable, "Node was null");
        Objects.requireNonNull(message, "Message was null");
        Objects.requireNonNull(formatArgs, "Format arguments were null, use an empty array");
        Node nearestNode = this.getNearestNode(reportable, astInfo);
        RuleViolation violation = this.createViolation(reportable, astInfo, nearestNode, message, formatArgs);
        this.listener.onRuleViolation(violation);
    }

    private RuleViolation createViolation(Reportable reportable, AstInfo<?> astInfo, Node nearestNode, String message, Object ... formatArgs) {
        LanguageVersionHandler handler = astInfo.getLanguageProcessor().services();
        Map<String, String> extraVariables = ViolationDecorator.apply(handler.getViolationDecorator(), nearestNode);
        String description = this.makeMessage(message, formatArgs, extraVariables);
        FileLocation location = reportable.getReportLocation();
        return new ParametricRuleViolation(this.rule, location, description, extraVariables);
    }

    private Node getNearestNode(Reportable reportable, AstInfo<?> astInfo) {
        if (reportable instanceof Node) {
            return (Node)reportable;
        }
        int startOffset = RuleContext.getStartOffset(reportable, astInfo);
        Optional<Node> foundNode = NodeFindingUtil.findNodeAt(astInfo.getRootNode(), startOffset);
        return foundNode.orElse((Node)astInfo.getRootNode());
    }

    private static int getStartOffset(Reportable reportable, AstInfo<?> astInfo) {
        if (reportable instanceof JavaccToken) {
            return ((JavaccToken)reportable).getRegion().getStartOffset();
        }
        FileLocation loc = reportable.getReportLocation();
        return astInfo.getTextDocument().offsetAtLineColumn(loc.getStartPos());
    }

    private static @Nullable Report.SuppressedViolation suppressOrNull(Node location, RuleViolation rv, AstInfo<?> astInfo) {
        LanguageVersionHandler handler = astInfo.getLanguageProcessor().services();
        Report.SuppressedViolation suppressed = ViolationSuppressor.suppressOrNull(handler.getExtraViolationSuppressors(), rv, location);
        if (suppressed == null) {
            suppressed = ViolationSuppressor.suppressOrNull(DEFAULT_SUPPRESSORS, rv, location);
        }
        return suppressed;
    }

    private String makeMessage(@NonNull String message, Object[] args, Map<String, String> extraVars) {
        String escapedMessage = StringUtils.replace((String)message, (String)"${", (String)"$'{'");
        String formatted = MessageFormat.format(escapedMessage, args);
        return this.expandVariables(formatted, extraVars);
    }

    private String expandVariables(String message, Map<String, String> extraVars) {
        if (!message.contains("${")) {
            return message;
        }
        StringBuilder buf = new StringBuilder(message);
        int startIndex = -1;
        while ((startIndex = buf.indexOf("${", startIndex + 1)) >= 0) {
            String name;
            String variableValue;
            int endIndex = buf.indexOf("}", startIndex);
            if (endIndex < 0 || (variableValue = this.getVariableValue(name = buf.substring(startIndex + 2, endIndex), extraVars)) == null) continue;
            buf.replace(startIndex, endIndex + 1, variableValue);
        }
        return buf.toString();
    }

    private String getVariableValue(String name, Map<String, String> extraVars) {
        String value = extraVars.get(name);
        if (value != null) {
            return value;
        }
        PropertyDescriptor<?> propertyDescriptor = this.rule.getPropertyDescriptor(name);
        return propertyDescriptor == null ? null : String.valueOf(this.rule.getProperty(propertyDescriptor));
    }
}

