/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;

public class TextRenderer
extends AbstractIncrementingRenderer {
    private static final char SMALL_SEPARATOR = ':';
    private static final String MEDIUM_SEPARATOR = ":\t";
    private static final String LARGE_SEPARATOR = "\t-\t";
    public static final String NAME = "text";

    public TextRenderer() {
        super(NAME, "Text format.");
    }

    @Override
    public String defaultFileExtension() {
        return "txt";
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        StringBuilder buf = new StringBuilder();
        while (violations.hasNext()) {
            buf.setLength(0);
            RuleViolation rv = violations.next();
            buf.append(this.determineFileName(rv.getFileId()));
            buf.append(':').append(rv.getBeginLine());
            buf.append(MEDIUM_SEPARATOR).append(rv.getRule().getName());
            buf.append(MEDIUM_SEPARATOR).append(rv.getDescription());
            this.writer.println(buf);
        }
    }

    @Override
    public void end() throws IOException {
        StringBuilder buf = new StringBuilder(500);
        for (Object error : this.errors) {
            buf.setLength(0);
            buf.append(this.determineFileName(((Report.ProcessingError)error).getFileId()));
            buf.append(LARGE_SEPARATOR).append(((Report.ProcessingError)error).getMsg());
            this.writer.println(buf);
        }
        for (Report.SuppressedViolation excluded : this.suppressed) {
            buf.setLength(0);
            buf.append(excluded.getRuleViolation().getRule().getName()).append(" rule violation suppressed by ").append(excluded.getSuppressor().getId()).append(" in ").append(this.determineFileName(excluded.getRuleViolation().getFileId()));
            this.writer.println(buf);
        }
        for (Object error : this.configErrors) {
            buf.setLength(0);
            buf.append(((Report.ConfigurationError)error).rule().getName());
            buf.append(LARGE_SEPARATOR).append(((Report.ConfigurationError)error).issue());
            this.writer.println(buf);
        }
    }
}

