/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Objects;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;
import net.sourceforge.pmd.properties.internal.PropertyTypeId;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PropertyDescriptor<T> {
    private final PropertySerializer<T> parser;
    private final PropertyTypeId typeId;
    private final String name;
    private final String description;
    private final T defaultValue;
    private final boolean isXPathAvailable;

    PropertyDescriptor(String name, String description, T defaultValue, PropertySerializer<T> parser, @Nullable PropertyTypeId typeId, boolean isXPathAvailable) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.typeId = typeId;
        this.isXPathAvailable = isXPathAvailable;
        PropertyParsingUtil.checkConstraintsThrow(defaultValue, parser.getConstraints());
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public PropertySerializer<T> serializer() {
        return this.parser;
    }

    @Nullable PropertyTypeId getTypeId() {
        return this.typeId;
    }

    public boolean isXPathAvailable() {
        return this.isXPathAvailable;
    }

    public String toString() {
        return "PropertyDescriptor{ name='" + this.name + '\'' + ", parser=" + this.parser + ", typeId=" + (Object)((Object)this.typeId) + ", description='" + this.description + '\'' + ", defaultValue=" + this.defaultValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDescriptor that = (PropertyDescriptor)o;
        return this.name.equals(that.name) && this.description.equals(that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }
}

