/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.xpath.PmdXPathException;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathHandler;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstNodeOwner;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstTreeInfo;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.xpath.internal.DomainConversion;
import net.sourceforge.pmd.lang.rule.xpath.internal.RuleChainAnalyzer;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonExprTransformations;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonExtensionFunctionDefinitionAdapter;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.DataMap;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaxonXPathRuleQuery {
    static final String AST_ROOT = "_AST_ROOT_";
    private static final Logger LOG = LoggerFactory.getLogger(SaxonXPathRuleQuery.class);
    private static final NamePool NAME_POOL = new NamePool();
    private static final DataMap.SimpleDataKey<AstTreeInfo> SAXON_TREE_CACHE_KEY = DataMap.simpleDataKey("saxon.tree");
    private final String xpathExpr;
    private final XPathVersion version;
    private final Map<PropertyDescriptor<?>, Object> properties;
    private final XPathHandler xPathHandler;
    private final List<String> rulechainQueries = new ArrayList<String>();
    private Configuration configuration;
    Map<String, List<Expression>> nodeNameToXPaths = new HashMap<String, List<Expression>>();
    XPathExpression xpathExpression;
    private final DeprecatedAttrLogger attrCtx;

    public SaxonXPathRuleQuery(String xpathExpr, XPathVersion version, Map<PropertyDescriptor<?>, Object> properties, XPathHandler xPathHandler, DeprecatedAttrLogger logger) throws PmdXPathException {
        this.xpathExpr = xpathExpr;
        this.version = version;
        this.properties = properties;
        this.xPathHandler = xPathHandler;
        this.attrCtx = logger;
        try {
            this.initialize();
        }
        catch (XPathException e) {
            throw this.wrapException(e, PmdXPathException.Phase.INITIALIZATION);
        }
    }

    public String getXpathExpression() {
        return this.xpathExpr;
    }

    public List<String> getRuleChainVisits() {
        return this.rulechainQueries;
    }

    public List<Node> evaluate(Node node) {
        AstTreeInfo documentNode = this.getDocumentNodeForRootNode(node);
        documentNode.setAttrCtx(this.attrCtx);
        try {
            XPathDynamicContext xpathDynamicContext = this.xpathExpression.createDynamicContext((Item)documentNode.findWrapperFor(node));
            LinkedHashSet<Node> results = new LinkedHashSet<Node>();
            List<Expression> expressions = this.getExpressionsForLocalNameOrDefault(node.getXPathNodeName());
            for (Expression expression : expressions) {
                SequenceIterator iterator = expression.iterate(xpathDynamicContext.getXPathContextObject());
                Item current = iterator.next();
                while (current != null) {
                    if (!(current instanceof AstNodeOwner)) {
                        throw new XPathException("XPath rule expression returned a non-node (" + current.getClass() + "): " + current);
                    }
                    results.add(((AstNodeOwner)current).getUnderlyingNode());
                    current = iterator.next();
                }
            }
            ArrayList<Node> sortedRes = new ArrayList<Node>(results);
            sortedRes.sort(RuleChainAnalyzer.documentOrderComparator());
            ArrayList<Node> arrayList = sortedRes;
            return arrayList;
        }
        catch (XPathException e) {
            throw this.wrapException(e, PmdXPathException.Phase.EVALUATION);
        }
        catch (UncheckedXPathException e) {
            throw this.wrapException(e.getXPathException(), PmdXPathException.Phase.EVALUATION);
        }
        finally {
            documentNode.setAttrCtx(DeprecatedAttrLogger.noop());
        }
    }

    private ContextedRuntimeException wrapException(XPathException e, PmdXPathException.Phase phase) {
        return new PmdXPathException(e, phase, this.xpathExpr, this.version);
    }

    List<Expression> getExpressionsForLocalNameOrDefault(String nodeName) {
        List<Expression> expressions = this.nodeNameToXPaths.get(nodeName);
        if (expressions != null) {
            return expressions;
        }
        return this.nodeNameToXPaths.get(AST_ROOT);
    }

    Expression getFallbackExpr() {
        return this.nodeNameToXPaths.get(AST_ROOT).get(0);
    }

    private AstTreeInfo getDocumentNodeForRootNode(Node node) {
        RootNode root = node.getRoot();
        return root.getUserMap().computeIfAbsent(SAXON_TREE_CACHE_KEY, () -> new AstTreeInfo(root, this.configuration));
    }

    private void addExpressionForNode(String nodeName, Expression expression) {
        this.nodeNameToXPaths.computeIfAbsent(nodeName, n -> new ArrayList(2)).add(expression);
    }

    private void initialize() throws XPathException {
        this.configuration = Configuration.newConfiguration();
        this.configuration.setNamePool(SaxonXPathRuleQuery.getNamePool());
        StaticContextWithProperties staticCtx = new StaticContextWithProperties(this.configuration);
        staticCtx.setXPathLanguageLevel(this.version == XPathVersion.XPATH_3_1 ? 31 : 20);
        staticCtx.declareNamespace("fn", NamespaceUri.FN);
        for (PropertyDescriptor<?> propertyDescriptor : this.properties.keySet()) {
            String name = propertyDescriptor.name();
            if ("xpath".equals(name)) continue;
            staticCtx.declareProperty(propertyDescriptor);
        }
        for (XPathFunctionDefinition xpathFun : this.xPathHandler.getRegisteredExtensionFunctions()) {
            SaxonExtensionFunctionDefinitionAdapter fun = new SaxonExtensionFunctionDefinitionAdapter(xpathFun);
            StructuredQName qname = fun.getFunctionQName();
            staticCtx.declareNamespace(qname.getPrefix(), qname.getNamespaceUri());
            this.configuration.registerExtensionFunction((ExtensionFunctionDefinition)fun);
        }
        XPathEvaluator xpathEvaluator = new XPathEvaluator(this.configuration);
        xpathEvaluator.setStaticContext((XPathStaticContext)staticCtx);
        this.xpathExpression = xpathEvaluator.createExpression(this.xpathExpr);
        this.analyzeXPathForRuleChain(xpathEvaluator);
    }

    private void analyzeXPathForRuleChain(XPathEvaluator xpathEvaluator) {
        Expression expr = this.xpathExpression.getInternalExpression();
        boolean useRuleChain = true;
        Iterable<Expression> subexpressions = SaxonExprTransformations.splitUnions(expr);
        Iterator<Expression> iterator = subexpressions.iterator();
        while (iterator.hasNext()) {
            Expression subexpression;
            Expression modified = subexpression = iterator.next();
            modified = SaxonExprTransformations.hoistFilters(modified);
            modified = SaxonExprTransformations.reduceRoot(modified);
            modified = SaxonExprTransformations.copyTopLevelLets(modified, expr);
            RuleChainAnalyzer rca = new RuleChainAnalyzer(xpathEvaluator.getConfiguration());
            Expression finalExpr = rca.visit(modified);
            if (!rca.getRootElements().isEmpty()) {
                rca.getRootElements().forEach(it -> this.addExpressionForNode((String)it, finalExpr));
                continue;
            }
            useRuleChain = false;
            break;
        }
        if (useRuleChain) {
            this.rulechainQueries.addAll(this.nodeNameToXPaths.keySet());
        } else {
            this.nodeNameToXPaths.clear();
            LOG.debug("Unable to use RuleChain for XPath: {}", (Object)this.xpathExpr);
        }
        this.addExpressionForNode(AST_ROOT, this.xpathExpression.getInternalExpression());
    }

    public static NamePool getNamePool() {
        return NAME_POOL;
    }

    final class StaticContextWithProperties
    extends IndependentContext {
        private final Map<StructuredQName, PropertyDescriptor<?>> propertiesByName;

        StaticContextWithProperties(Configuration config) {
            super(config);
            this.propertiesByName = new HashMap();
            this.getPackageData().setSchemaAware(true);
        }

        public void declareProperty(PropertyDescriptor<?> prop) {
            XPathVariable var = this.declareVariable(null, prop.name());
            this.propertiesByName.put(var.getVariableQName(), prop);
        }

        public Expression bindVariable(StructuredQName qName) throws XPathException {
            LocalVariableReference local = (LocalVariableReference)super.bindVariable(qName);
            PropertyDescriptor<?> prop = this.propertiesByName.get(qName);
            if (prop == null || prop.defaultValue() == null) {
                return local;
            }
            Object actualValue = SaxonXPathRuleQuery.this.properties.getOrDefault(prop, prop.defaultValue());
            AtomicSequence converted = DomainConversion.convert(actualValue);
            local.setStaticType(null, (GroundedValue)converted, 0);
            return local;
        }
    }
}

