/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionException;
import net.sourceforge.pmd.lang.rule.xpath.internal.XPathElementToNodeHelper;

public class SaxonExtensionFunctionDefinitionAdapter
extends ExtensionFunctionDefinition {
    private static final SequenceType SINGLE_ELEMENT_SEQUENCE_TYPE = NodeKindTest.ELEMENT.one();
    private final XPathFunctionDefinition definition;

    public SaxonExtensionFunctionDefinitionAdapter(XPathFunctionDefinition definition) {
        this.definition = definition;
    }

    private SequenceType convertToSequenceType(XPathFunctionDefinition.Type type) {
        switch (type) {
            case SINGLE_STRING: {
                return SequenceType.SINGLE_STRING;
            }
            case SINGLE_BOOLEAN: {
                return SequenceType.SINGLE_BOOLEAN;
            }
            case SINGLE_ELEMENT: {
                return SINGLE_ELEMENT_SEQUENCE_TYPE;
            }
            case SINGLE_INTEGER: {
                return SequenceType.SINGLE_INTEGER;
            }
            case STRING_SEQUENCE: {
                return SequenceType.STRING_SEQUENCE;
            }
            case OPTIONAL_STRING: {
                return SequenceType.OPTIONAL_STRING;
            }
            case OPTIONAL_DECIMAL: {
                return SequenceType.OPTIONAL_DECIMAL;
            }
        }
        throw new UnsupportedOperationException("Type " + (Object)((Object)type) + " is not supported");
    }

    private SequenceType[] convertToSequenceTypes(XPathFunctionDefinition.Type[] types) {
        SequenceType[] result = new SequenceType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.convertToSequenceType(types[i]);
        }
        return result;
    }

    public StructuredQName getFunctionQName() {
        QName qName = this.definition.getQName();
        return new StructuredQName(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart());
    }

    public SequenceType[] getArgumentTypes() {
        return this.convertToSequenceTypes(this.definition.getArgumentTypes());
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return this.convertToSequenceType(this.definition.getResultType());
    }

    public boolean dependsOnFocus() {
        return this.definition.dependsOnContext();
    }

    public ExtensionFunctionCall makeCallExpression() {
        final XPathFunctionDefinition.FunctionCall call = this.definition.makeCallExpression();
        return new ExtensionFunctionCall(){

            public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
                Object[] convertedArguments = new Object[SaxonExtensionFunctionDefinitionAdapter.this.definition.getArgumentTypes().length];
                for (int i = 0; i < convertedArguments.length; ++i) {
                    if (!(arguments[i] instanceof StringLiteral)) continue;
                    convertedArguments[i] = ((StringLiteral)arguments[i]).getString().toString();
                }
                try {
                    call.staticInit(convertedArguments);
                }
                catch (XPathFunctionException e) {
                    XPathException xPathException = new XPathException((Throwable)e);
                    xPathException.setIsStaticError(true);
                    throw xPathException;
                }
                return null;
            }

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                Node contextNode = null;
                if (SaxonExtensionFunctionDefinitionAdapter.this.definition.dependsOnContext()) {
                    contextNode = XPathElementToNodeHelper.itemToNode(context.getContextItem());
                }
                Object[] convertedArguments = new Object[SaxonExtensionFunctionDefinitionAdapter.this.definition.getArgumentTypes().length];
                block14: for (int i = 0; i < convertedArguments.length; ++i) {
                    switch (SaxonExtensionFunctionDefinitionAdapter.this.definition.getArgumentTypes()[i]) {
                        case SINGLE_STRING: {
                            convertedArguments[i] = arguments[i].head().getStringValue();
                            continue block14;
                        }
                        case SINGLE_ELEMENT: {
                            convertedArguments[i] = arguments[i].head();
                            continue block14;
                        }
                        default: {
                            throw new UnsupportedOperationException("Don't know how to convert argument type " + (Object)((Object)SaxonExtensionFunctionDefinitionAdapter.this.definition.getArgumentTypes()[i]));
                        }
                    }
                }
                Object result = null;
                try {
                    result = call.call(contextNode, convertedArguments);
                }
                catch (XPathFunctionException e) {
                    throw new XPathException((Throwable)e);
                }
                BooleanValue convertedResult = null;
                switch (SaxonExtensionFunctionDefinitionAdapter.this.definition.getResultType()) {
                    case SINGLE_BOOLEAN: {
                        convertedResult = BooleanValue.get((boolean)((Boolean)result));
                        break;
                    }
                    case SINGLE_INTEGER: {
                        convertedResult = Int64Value.makeIntegerValue((long)((Integer)result).intValue());
                        break;
                    }
                    case SINGLE_STRING: {
                        convertedResult = new StringValue((String)result);
                        break;
                    }
                    case OPTIONAL_STRING: {
                        convertedResult = result instanceof Optional && ((Optional)result).isPresent() ? new StringValue((String)((Optional)result).get()) : EmptyAtomicSequence.getInstance();
                        break;
                    }
                    case STRING_SEQUENCE: {
                        convertedResult = result instanceof List ? new SequenceExtent.Of(((List)result).stream().map(StringValue::new).collect(Collectors.toList())) : EmptySequence.getInstance();
                        break;
                    }
                    case OPTIONAL_DECIMAL: {
                        convertedResult = result instanceof Optional && ((Optional)result).isPresent() ? new BigDecimalValue(((Double)((Optional)result).get()).doubleValue()) : EmptySequence.getInstance();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Don't know how to convert result type " + (Object)((Object)SaxonExtensionFunctionDefinitionAdapter.this.definition.getResultType()));
                    }
                }
                return convertedResult;
            }
        };
    }
}

