/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.Collections;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonExprVisitor;
import net.sourceforge.pmd.lang.rule.xpath.internal.SplitUnions;

final class SaxonExprTransformations {
    private static final SaxonExprVisitor FILTER_HOISTER = new SaxonExprVisitor(){

        @Override
        public Expression visit(SlashExpression e) {
            Expression left = super.visit(e.getLhsExpression());
            Expression right = super.visit(e.getRhsExpression());
            if (right instanceof FilterExpression) {
                Expression middle = ((FilterExpression)right).getBase();
                Expression filter = ((FilterExpression)right).getFilter();
                return new FilterExpression((Expression)new SlashExpression(left, middle), filter);
            }
            return super.visit(e);
        }
    };
    private static final SaxonExprVisitor ROOT_REDUCER = new SaxonExprVisitor(){

        @Override
        public Expression visit(SlashExpression e) {
            Expression left = super.visit(e.getLhsExpression());
            Expression right = super.visit(e.getRhsExpression());
            if (right instanceof AxisExpression && ((AxisExpression)right).getAxis() == 3 && left instanceof SlashExpression) {
                Expression leftLeft = ((SlashExpression)left).getLhsExpression();
                Expression leftRight = ((SlashExpression)left).getRhsExpression();
                if (leftLeft instanceof RootExpression && leftRight instanceof AxisExpression && ((AxisExpression)leftRight).getAxis() == 5 && this.isAnyNode(((AxisExpression)leftRight).getNodeTest())) {
                    left = leftLeft;
                    right = new AxisExpression(4, ((AxisExpression)right).getNodeTest());
                }
            }
            return new SlashExpression(left, right);
        }

        private boolean isAnyNode(NodeTest nodeTest) {
            return nodeTest == null || nodeTest instanceof AnyNodeTest;
        }
    };

    private SaxonExprTransformations() {
    }

    static Expression hoistFilters(Expression expression) {
        return FILTER_HOISTER.visit(expression);
    }

    static Expression reduceRoot(Expression expression) {
        return ROOT_REDUCER.visit(expression);
    }

    static Iterable<Expression> splitUnions(Expression expr) {
        SplitUnions unions = new SplitUnions();
        unions.visit(expr);
        if (unions.getExpressions().isEmpty()) {
            return Collections.singletonList(expr);
        }
        return unions.getExpressions();
    }

    static Expression copyTopLevelLets(final Expression subexpr, Expression original) {
        if (!(original instanceof LetExpression)) {
            return subexpr;
        }
        if (subexpr instanceof LetExpression) {
            LetExpression letSubexpr = (LetExpression)subexpr;
            LetExpression letOriginal = (LetExpression)original;
            if (letOriginal.getVariableQName().equals((Object)letSubexpr.getVariableQName()) && letSubexpr.getSequence().toString().equals(letOriginal.getSequence().toString())) {
                return subexpr;
            }
        }
        SaxonExprVisitor topLevelLetCopier = new SaxonExprVisitor(){

            @Override
            public Expression visit(LetExpression e) {
                if (e.getAction() instanceof LetExpression) {
                    return super.visit(e);
                }
                Expression sequence = this.visit(e.getSequence());
                LetExpression result = new LetExpression();
                result.setAction(subexpr);
                result.setSequence(sequence);
                result.setVariableQName(e.getVariableQName());
                result.setRequiredType(e.getRequiredType());
                result.setSlotNumber(e.getLocalSlotNumber());
                return result;
            }
        };
        if (original instanceof LetExpression) {
            return topLevelLetCopier.visit(original);
        }
        return subexpr;
    }
}

