/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.internal.PmdDocumentSorter;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonExprVisitor;
import net.sourceforge.pmd.util.CollectionUtil;

public class RuleChainAnalyzer
extends SaxonExprVisitor {
    private final Configuration configuration;
    private List<String> rootElement;
    private boolean rootElementReplaced;
    private boolean insideExpensiveExpr;
    private boolean foundPathInsideExpensive;
    private boolean foundCombinedNodeTest;

    public RuleChainAnalyzer(Configuration currentConfiguration) {
        this.configuration = currentConfiguration;
    }

    public List<String> getRootElements() {
        if (!this.foundPathInsideExpensive && this.rootElementReplaced) {
            return this.rootElement == null ? Collections.emptyList() : this.rootElement;
        }
        return Collections.emptyList();
    }

    @Override
    public Expression visit(DocumentSorter e) {
        DocumentSorter result = (DocumentSorter)super.visit(e);
        return result.getBaseExpression();
    }

    public Expression visitSlashPreserveRootElement(SlashExpression e) {
        Expression start = this.visit(e.getStart());
        List<String> elt = this.rootElement;
        boolean replaced = this.rootElementReplaced;
        Expression step = this.visit(e.getStep());
        if (!(e.getStart() instanceof RootExpression)) {
            this.rootElement = elt;
            this.rootElementReplaced = replaced;
        }
        return new SlashExpression(start, step);
    }

    @Override
    public Expression visit(SlashExpression e) {
        if (!this.insideExpensiveExpr && this.rootElement == null) {
            Expression result = this.visitSlashPreserveRootElement(e);
            if (this.rootElement != null && !this.rootElementReplaced) {
                if (result instanceof SlashExpression) {
                    SlashExpression newPath = (SlashExpression)result;
                    Expression step = newPath.getStep();
                    if (step instanceof FilterExpression) {
                        FilterExpression filterExpression = (FilterExpression)step;
                        ArrayDeque<Expression> filters = new ArrayDeque<Expression>();
                        FilterExpression walker = filterExpression;
                        while (walker instanceof FilterExpression) {
                            filters.push(walker.getFilter());
                            walker = walker.getBase();
                        }
                        result = new FilterExpression((Expression)new AxisExpression(12, null), (Expression)filters.pop());
                        while (!filters.isEmpty()) {
                            result = new FilterExpression(result, (Expression)filters.pop());
                        }
                        this.rootElementReplaced = true;
                    } else if (step instanceof AxisExpression) {
                        Expression start = newPath.getStart();
                        if (start instanceof RootExpression) {
                            result = new AxisExpression(12, null);
                        } else if (start instanceof VennExpression) {
                            this.rootElement = null;
                            result = e;
                        } else {
                            result = new SlashExpression(start, (Expression)new AxisExpression(12, null));
                        }
                        this.rootElementReplaced = true;
                    }
                } else {
                    result = new AxisExpression(5, null);
                    this.rootElementReplaced = true;
                }
            }
            return result;
        }
        if (this.insideExpensiveExpr) {
            this.foundPathInsideExpensive = true;
        }
        return super.visit(e);
    }

    @Override
    public Expression visit(AxisExpression e) {
        if (this.rootElement == null && e.getNodeTest() instanceof NameTest && !this.foundCombinedNodeTest) {
            NameTest test = (NameTest)e.getNodeTest();
            if (test.getPrimitiveType() == 1 && e.getAxis() == 4) {
                this.rootElement = CollectionUtil.listOf(this.configuration.getNamePool().getClarkName(test.getFingerprint()), new String[0]);
            } else if (test.getPrimitiveType() == 1 && e.getAxis() == 3) {
                this.rootElement = CollectionUtil.listOf(this.configuration.getNamePool().getClarkName(test.getFingerprint()), new String[0]);
            }
        } else if (e.getNodeTest() instanceof CombinedNodeTest) {
            this.foundCombinedNodeTest = true;
        }
        return super.visit(e);
    }

    @Override
    public Expression visit(LetExpression e) {
        if (e.getSequence().getCost() >= 20.0) {
            boolean prevCtx = this.insideExpensiveExpr;
            this.insideExpensiveExpr = true;
            Expression result = super.visit(e);
            this.insideExpensiveExpr = prevCtx;
            return result;
        }
        return super.visit(e);
    }

    @Override
    public Expression visit(VennExpression e) {
        return e;
    }

    public static Comparator<Node> documentOrderComparator() {
        return PmdDocumentSorter.INSTANCE;
    }
}

